% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_list_spatialpolygons}
\alias{BIEN_list_spatialpolygons}
\title{Extract a list of species within a given spatialpolygons.}
\usage{
BIEN_list_spatialpolygons(spatialpolygons, cultivated = FALSE,
  only.new.world = TRUE, ...)
}
\arguments{
\item{spatialpolygons}{An object of class SpatialPolygonsDataFrame.  Note that the object must be in WGS84.}

\item{cultivated}{Return cultivated records as well?  Default is FALSE.}

\item{only.new.world}{Return only records from the New World?  Default is true}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
Dataframe containing a list of all species with occurrences in the supplied SpatialPolygons object.
}
\description{
BIEN_list_spatialpolygons produces a list of all species with occurrence record falling within a user-supplied SpatialPolygons or SpatialPolygonsDataFrame.
}
\note{
We recommend using \code{\link[rgdal]{readOGR}} to load spatial data.  Other methods may cause problems related to handling holes in polygons.
}
\examples{
\dontrun{
BIEN_ranges_species("Carnegiea gigantea")#saves ranges to the current working directory
shape<-readOGR(dsn = ".",layer = "Carnegiea_gigantea")
#spatialpolygons should be read with readOGR(), see note.
species_list<-BIEN_list_spatialpolygons(spatialpolygons=shape)}
}
\seealso{
Other list functions: \code{\link{BIEN_list_all}},
  \code{\link{BIEN_list_country}},
  \code{\link{BIEN_list_county}},
  \code{\link{BIEN_list_state}}
}
