% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_plot_datasource}
\alias{BIEN_plot_datasource}
\title{Download plot data from a given datasource.}
\usage{
BIEN_plot_datasource(datasource, cultivated = FALSE, only.new.world = TRUE,
  all.taxonomy = FALSE, native.status = FALSE, natives.only = TRUE,
  political.boundaries = FALSE, collection.info = F, all.metadata = FALSE,
  ...)
}
\arguments{
\item{datasource}{A datasource. See \code{\link{BIEN_plot_list_datasource}} for options.}

\item{cultivated}{Return cultivated records as well?  Default is FALSE.}

\item{only.new.world}{Return only records from the New World?  Default is true}

\item{all.taxonomy}{Return all taxonomic information?  This includes the raw data as well as the "scrubbed" data.}

\item{native.status}{Return information on introduction status?  The default value is FALSE. A value of TRUE also returns additional information on introduction status.}

\item{natives.only}{Exclude detected introduced species?  Default is TRUE.}

\item{political.boundaries}{Return information on political boundaries for an observation? The default value is FALSE.}

\item{collection.info}{Return additional information about collection and identification? The default value is FALSE.}

\item{all.metadata}{Should additional plot metadata be returned?  Default is FALSE.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
A dataframe containing all data from the specified datasource.
}
\description{
BIEN_plot_datasource downloads all plot data from a given datasource.
}
\note{
US FIA coordinates have been fuzzed and swapped, for more details see: https://www.fia.fs.fed.us/tools-data/spatial/Policy/index.php
}
\examples{
\dontrun{
BIEN_plot_datasource("SALVIAS")}
}
\seealso{
Other plot functions: \code{\link{BIEN_plot_country}},
  \code{\link{BIEN_plot_dataset}},
  \code{\link{BIEN_plot_list_datasource}},
  \code{\link{BIEN_plot_list_sampling_protocols}},
  \code{\link{BIEN_plot_metadata}},
  \code{\link{BIEN_plot_name}},
  \code{\link{BIEN_plot_sampling_protocol}},
  \code{\link{BIEN_plot_state}}
}
