% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_trait_genus}
\alias{BIEN_trait_genus}
\title{Download trait data for given genera.}
\usage{
BIEN_trait_genus(
  genus,
  all.taxonomy = FALSE,
  political.boundaries = FALSE,
  source.citation = FALSE,
  ...
)
}
\arguments{
\item{genus}{A single genus or a vector of genera.}

\item{all.taxonomy}{Should full taxonomic information and TNRS output be returned?  Default is FALSE.}

\item{political.boundaries}{Should political boundary information (country, state, etc.) be returned?  Default is FALSE.}

\item{source.citation}{Should readable source information be downloaded for each record?  Note that \code{\link{BIEN_metadata_citation}} may be more useful.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
A dataframe of all data matching the specified genera.
}
\description{
BIEN_trait_genus extracts entries that contain the specified genera.
}
\examples{
\dontrun{
BIEN_trait_genus("Acer")
genus_vector <- c("Acer","Abies")
BIEN_trait_genus(genus_vector)}
}
\concept{trait funcitons}
