% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_occurrence_records_per_species}
\alias{BIEN_occurrence_records_per_species}
\title{Count the number of (geoValid) occurrence records for each species in BIEN}
\usage{
BIEN_occurrence_records_per_species(species = NULL, ...)
}
\arguments{
\item{species}{A single species, or vector of species.  If NULL, the default, it will return counts for all species.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
A dataframe listing the number of geovalidated occurrence records for each species in the BIEN database.
}
\description{
BIEN_occurrence_records_per_species downloads a count of the number of geovalidated occurrence records for each species in the BIEN database.
}
\examples{
\dontrun{
occurrence_counts<-BIEN_occurrence_records_per_species()}
}
\seealso{
Other occurrence functions: 
\code{\link{BIEN_occurrence_box}()},
\code{\link{BIEN_occurrence_country}()},
\code{\link{BIEN_occurrence_county}()},
\code{\link{BIEN_occurrence_family}()},
\code{\link{BIEN_occurrence_genus}()},
\code{\link{BIEN_occurrence_sf}()},
\code{\link{BIEN_occurrence_species}()},
\code{\link{BIEN_occurrence_state}()}
}
\concept{occurrence functions}
