% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIGDAWG.R
\name{BIGDAWG}
\alias{BIGDAWG}
\title{BIGDAWG Main Wrapper Function}
\usage{
BIGDAWG(
  Data,
  HLA = TRUE,
  Run.Tests,
  Loci.Set,
  All.Pairwise = FALSE,
  Trim = FALSE,
  Res = 2,
  EVS.rm = FALSE,
  Missing = 2,
  Strict.Bin = FALSE,
  Cores.Lim = 1L,
  Results.Dir,
  Return = FALSE,
  Output = TRUE,
  Merge.Output = FALSE,
  Verbose = TRUE
)
}
\arguments{
\item{Data}{Name of the genotype data file.}

\item{HLA}{Logical Indicating whether data is HLA class I/II genotyping data only.}

\item{Run.Tests}{Specifics which tests to run.}

\item{Loci.Set}{Input list defining which loci to use for analyses (combinations permitted).}

\item{All.Pairwise}{Logical indicating whether all pairwise loci should be analyzed in haplotype analysis.}

\item{Trim}{Logical indicating if HLA alleles should be trimmed to a set resolution.}

\item{Res}{Numeric setting what desired resolution to trim HLA alleles.}

\item{EVS.rm}{Logical indicating if expression variant suffixes should be removed.}

\item{Missing}{Numeric setting allowable missing data for running analysis (may use "ignore").}

\item{Strict.Bin}{Logical specify if strict rare cell binning should be used in ChiSq test.}

\item{Cores.Lim}{Integer setting the number of cores accessible to BIGDAWG (Windows limit is 1 core).}

\item{Results.Dir}{Optional, string of full path directory name for BIGDAWG output.}

\item{Return}{Logical Should analysis results be returned as list.}

\item{Output}{Logical Should analysis results be written to output directory.}

\item{Merge.Output}{Logical Should analysis results be merged into a single file for easy access.}

\item{Verbose}{Logical Should a summary of each analysis be displayed in console.}
}
\description{
This is the main wrapper function for each analysis.
}
\examples{
### The following examples use the synthetic data set bundled with BIGDAWG

# Haplotype analysis with no missing genotypes for two loci sets
# Significant haplotype association with phenotype
# BIGDAWG(Data="HLA_data", Run.Tests="H", Missing=0, Loci.Set=list(c("DRB1","DQB1")))

# Hardy-Weinberg and Locus analysis ignoring missing data
# Significant locus associations with phenotype at all but DQB1
# BIGDAWG(Data="HLA_data", Run.Tests="L", Missing="ignore")

# Hardy-Weinberg analysis trimming data to 2-Field resolution with no output to files (console only)
# Significant locus deviation at DQB1
BIGDAWG(Data="HLA_data", Run.Tests="HWE", Trim=TRUE, Res=2, Output=FALSE)
}
