% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biodiversityFunctions.R
\name{communityMatrixGrid}
\alias{communityMatrixGrid}
\title{Creates a community matrix per grid cell (sample x species x grid cell)}
\usage{
communityMatrixGrid(x)
}
\arguments{
\item{x}{an object of class \sQuote{SummarizeBirds}.}
}
\value{
a \code{list} with a \code{data.frame} per grid cell with counts of
observations for each species per visits on each non-empty grid cell.
}
\description{
A function that counts for each grid cell the number of observations per visit
for each species.
}
\examples{
\donttest{
grid <- makeGrid(searchPolygon, gridSize = 10)
OB <- organizeBirds(bombusObs, sppCol = "scientificName",
                    taxonRankCol = "taxonRank", taxonRank = "SPECIES",
                    simplifySppName = TRUE)
SB <- summarizeBirds(OB, grid=grid)
CM <- communityMatrixGrid(SB)
lCM <- lengths(CM) ## Which cells are empty
## library(vegan)
## R <- lapply(CM[which(lCM>0)], specaccum)
}
}
\seealso{
\code{\link{communityMatrix}}
}
