% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputeConstant.R
\encoding{UTF-8}
\name{imputeConstant}
\alias{imputeConstant}
\title{imputing BLOQ's with a constant value}
\usage{
imputeConstant(inputData, LOQ, constantValue)
}
\arguments{
\item{inputData}{numeric matrix or data frame of the size 
n by J (n the sample size and J the number of time points)
 the input dataset}

\item{LOQ}{scalar, limit of quantification value}

\item{constantValue}{scalar, the constant value which replaces
all BLOQ's, default is LOQ/2}
}
\value{
the imputed dataset: a numeric matrix or data frame of the size 
n by J (n the sample size and J the number of time points)
}
\description{
function to impute BLOQ observations by replacing them
with a constant value.
}
\examples{
# generate data from Beal model with only fixed effects
set.seed(111)
genDataFixedEffects <- simulateBealModelFixedEffects(10, 0.693,
		1, 1, seq(0.5,3,0.5))
# replacing BLOQ's with LOQ/2
imputeConstant(genDataFixedEffects, 0.1, 0.1/2)
}
\author{
Vahid Nassiri, Helen Yvette Barnett
}
