% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior.predictive3D.r
\name{posterior.predictive3D}
\alias{posterior.predictive3D}
\title{Posterior predictive density on the simplex, for three-dimensional extreme value  models.}
\usage{
posterior.predictive3D(
  post.sample,
  densityGrid,
  from = post.sample$Nbin + 1,
  to = post.sample$Nsim,
  thin = 40,
  npoints = 40,
  eps = 10^(-3),
  equi = T,
  displ = T,
  ...
)
}
\arguments{
\item{post.sample}{A posterior sample as returned by \code{\link{posteriorMCMC}}}

\item{densityGrid}{A function returning a \code{npoints*npoints}
matrix, representing a discretized version of the spectral density
on the two dimensional simplex.
The function should be compatible with \code{\link{dgridplot}}.
In particular, it must  use \code{\link{discretize}} to produce
the discretization grid. It must be of type  \cr
\code{function(par, npoints, eps, equi, displ,invisible,
... )}.
See \bold{Details} below.}

\item{from}{Integer or \code{NULL}. If \code{NULL}, the default value is used. Otherwise,  should be greater than \code{post.sample$Nbin}. Indicates the  index where the averaging process should start. Default to \code{post.sample$Nbin +1}}

\item{to}{Integer or \code{NULL}. If \code{NULL}, the default
value is used. Otherwise, must be lower than \code{Nsim+1}.
Indicates  where the averaging process should stop.
Default to \code{post.sample$Nsim}.}

\item{thin}{Thinning interval.}

\item{npoints}{The number of grid nodes on the squared grid containing the desired triangle.}

\item{eps}{Positive number:  minimum
distance from any node inside the simplex to  the simplex boundary}

\item{equi}{logical. Is the simplex represented as an equilateral triangle (if \code{TRUE}) or a right triangle (if \code{FALSE}) ?}

\item{displ}{logical. Should a plot be produced ?}

\item{...}{Additional graphical parameters and arguments to be passed
to \code{\link[graphics]{contour}}  and \code{\link[graphics]{image}}.}
}
\value{
A \code{npoints*npoints} matrix: the posterior predictive density.
}
\description{
Computes an approximation of the predictive density based on a  posterior parameters sample. Only allowed in the three-dimensional case.
}
\details{
The posterior predictive density is approximated by averaging the
densities produced by the function
\code{densityGrid(par, npoints, eps, equi, displ,invisible, ...)} for
\code{par} in a  subset of  the parameters sample stored in
\code{post.sample}. The arguments of \code{densityGrid} must be
\itemize{
\item \code{par}:  A vector containing the parameters.
\item \code{npoints, eps, equi}: Discretization parameters
to be passed to  \code{\link{dgridplot}}.
\item \code{displ}:  logical. Should a plot be produced ?
\item \code{invisible}: logical. Should the result be returned as \code{invisible} ?
\item \code{...} additional arguments to be passed to
\code{\link{dgridplot}}
}
Only a sub-sample is used: one out of \code{thin} parameters is used
(thinning). Further, only the parameters produced between time
\code{from} and time \code{to} (included) are kept.
}
\note{
The computational burden may be high: it is proportional to
\code{npoints^2}. Therefore, the function assigned to
\code{densityGridplot} should be
optimized, typically by calling \code{.C} with an internal,
user defined \code{C} function.
}
\seealso{
\code{\link{dgridplot}},  \code{\link{posteriorMCMC}}.
}
\author{
Anne Sabourin
}
