\name{summary.zlm}
\alias{summary.zlm}

\title{ Summarizing Linear Models under Zellner's g}

\description{summary method for class "\code{zlm}"}
\usage{
 \method{summary}{zlm}(object, printout = TRUE, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
\item{object}{ an object of class \code{zlm}: see "Examples" below }
\item{printout}{ If \code{TRUE} (default, then information is printed to console in a neat form }
\item{\dots}{	further arguments passed to or from other methods}
}
\details{
\code{summary.zlm} prints out coefficients expected values and their standard deviations, as well as information on the gprior and the log marginal likelihood. However, it invisbly returns a list with elements as described below:
}
\value{
A \code{\link{list}} with the following elements
  \item{residuals}{ The expected value of residuals from the model}
  \item{coefficients}{The posterior expected values of coefficents (including the intercept) }
  \item{coef.sd}{Posterior standard deviations of the coefficients (the intercept SD is \code{NA}, since an improper prior was used)}
  \item{gprior}{The g prior as it has been submitted to \code{object}}
  \item{E.shrinkage}{the shrinkage factor \eqn{g/(1+g)}, respectively its posterior expected value in case of a hyper-g prior}
  \item{SD.shrinkage}{(Optionally) the shrinkage factor's posterior standard deviation (in case of a hyper-g prior)}
  \item{log.lik}{The log marginal likelihood of the model}
}
\author{
Stefan Zeugner 
}
\seealso{
 \code{\link{zlm}} for creating \code{zlm} objects, \code{link{summary.lm}} for a similar function on OLS models
 
 See also \url{http://bms.zeugner.eu} for additional help.
}
\examples{
data(datafls)

#simple example
foo = zlm(datafls)
summary(foo)

sfoo = summary(foo,printout=FALSE)
print(sfoo$E.shrinkage)

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{utilities}
