% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmhyb.r
\name{SimulateTips}
\alias{SimulateTips}
\title{Simulate trait data}
\usage{
SimulateTips(phy.graph, sigma.sq = 1, mu = 0, bt = 1, vh = 0,
  SE = 0, measurement.error = 0, gamma = 0.5,
  exclude.donors.recipients = TRUE)
}
\arguments{
\item{phy.graph}{An ape::evonet object (a phylogeny stored in phylo format that also includes a reticulation matrix)}

\item{sigma.sq}{The Brownian motion wiggle rate}

\item{mu}{The population mean (in the absence of hybridization)}

\item{bt}{The beta value (multiplier on expected value for each hybridization event)}

\item{vh}{The burst of variance that comes from a hybridization event}

\item{SE}{Uniform uncertainty at the tips}

\item{measurement.error}{Uncertainty at the tips, especially if it varies between species}

\item{gamma}{In a hybridization event, what proportion of the trait comes from the donating parent. 0.5 means half comes from each parent}

\item{exclude.donors.recipients}{If TRUE, do not generate for any donors or recipient placeholder taxa}
}
\value{
A vector of trait values
}
\description{
For a given phylogenetic network generate tip data. Any values not specified use default values
}
\examples{
network <- SimulateNetwork(ntax=5, nhybridizations=2)
tips <- SimulateTips(network, mu=1.1, bt=3, vh=1.1, SE=1)
}
