% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Epaminicompact}
\alias{Epaminicompact}
\title{Fuel efficiency ratings for compact vehicles in 2001}
\format{A data frame/tibble with 22 observations on ten variables
\describe{ 
\item{class}{a character variable with value \code{MINICOMPACT CARS}} 
\item{manufacturer}{a character variable with values \code{AUDI},
\code{BMW}, \code{JAGUAR}, \code{MERCEDES-BENZ}, \code{MITSUBISHI}, and
\code{PORSCHE}} 
\item{carline}{a character variable with values \code{325CI
CONVERTIBLE}, \code{330CI CONVERTIBLE}, \code{911 CARRERA 2/4}, \code{911
TURBO}, \code{CLK320 (CABRIOLET)}, \code{CLK430 (CABRIOLET)}, \code{ECLIPSE
SPYDER}, \code{JAGUAR XK8 CONVERTIBLE}, \code{JAGUAR XKR CONVERTIBLE}, \code{M3
CONVERTIBLE}, \code{TT COUPE}, and \code{TT COUPE QUATTRO}} 
\item{displ}{engine displacement (in liters)} 
\item{cyl}{number of cylinders} 
\item{trans}{a factor with levels \code{Auto(L5)}, \code{Auto(S4)}, \code{Auto(S5)},
\code{Manual(M5)}, and \code{Manual(M6)}} 
\item{drv}{a factor with levels \code{4}(four wheel drive), \code{F}(front wheel drive), 
and \code{R}(rear wheel drive)} 
\item{cty}{city mpg}
\item{hwy}{highway mpg} 
\item{cmb}{combined city and highway mpg} 
}}
\source{
EPA data.
}
\usage{
Epaminicompact
}
\description{
Data for Exercise 1.65
}
\examples{

summary(Epaminicompact$cty)
plot(hwy ~ cty, data = Epaminicompact)

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
