% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsl.R
\name{bsl}
\alias{bsl}
\title{Performing BSL and BSLasso}
\usage{
bsl(y, n, M, start, cov_rw, fn_sim, fn_sum, penalty = NULL, fn_prior = NULL,
  sim_options = NULL, sum_options = NULL, standardise = FALSE,
  parallel = FALSE, parallel_packages = NULL, theta_names = NULL,
  verbose = TRUE)
}
\arguments{
\item{y}{The observed data - note this should be the raw dataset NOT the set of summary statistics.}

\item{n}{The number of simulations from the model per MCMC iteration.}

\item{M}{The number of MCMC iterations.}

\item{start}{Initial guess of the parameter value.}

\item{cov_rw}{A covariance matrix to be used in multivariate normal random walk proposals.}

\item{fn_sim}{A function that simulates data for a given parameter value. The function can have at most two arguments.
The first should be the vector of tuning parameters and the second (optional) argument should be a list of other necessary arguments. See \code{sim_options}.}

\item{fn_sum}{A function for computing summary statistics of data. The function can have at most two arguments.
The first should be the vector of tuning parameters and the second (optional) argument should be a list of other necessary arguments. See \code{sum_options}.}

\item{penalty}{The penalty value of the graphical lasso. BSLasso is performed if a numeric value is specified. The default is \code{NULL}, which means that BSL is performed.}

\item{fn_prior}{A function that computes the prior density for a parameter. The default is \code{NULL}, which is an improper flat prior over the real line for each parameter. The function must have a single input: the vector of proposed parameters.}

\item{sim_options}{A list of additional arguments to pass into the simulation function. Only use when the input \code{fn_sim} requires additional arguments. The default is \code{NULL}.}

\item{sum_options}{A list of additional arguments to pass into the summary statistics function. Only use when the input \code{fn_sum} requires additional arguments. The default is \code{NULL}.}

\item{standardise}{A logical argument that determines whether to standardise the summary statistics before applying the graphical lasso. This is only valid if penalty is not \code{NULL}.
The diagonal elements will not be penalised if the penalty is not \code{NULL}. The default is \code{FALSE}.}

\item{parallel}{A logical value indicating whether parallel computing should be used for simulation and summary statistic evaluation. Default is \code{FALSE}.}

\item{parallel_packages}{A character vector of package names to pass into the \code{foreach} function as argument '.package'. Only used when parallel computing is enabled, default is \code{NULL}.}

\item{theta_names}{A character vector of parameter names, which must has the same length as the parameter vector. The default is \code{NULL}.}

\item{verbose}{A logical argument indicating whether the iteration numbers (\code{1:M}) and accepted proposal flags should be printed to track progress. The default is \code{FALSE}.}
}
\value{
An object of class \code{bsl} is returned, containing the following components:
\itemize{
\item \code{theta}: MCMC samples from the joint approximate posterior distribution of the parameters.
\item \code{loglike}: MCMC samples of the estimated log-likelihood values.
\item \code{acceptanceRate}: The acceptance rate of the MCMC algorithm.
\item \code{earlyRejectionRate}: The early rejection rate of the algorithm (early rejection may occur when using bounded prior distributions).
\item \code{call}: The original code that was used to call the method.
\item \code{theta_names}: A character vector of parameter names.
}
The functions print(), summary() and plot() are all available for types of class \code{bsl}. Multiple results
can be plotted with overlapping densities using \code{\link{combinePlotsBSL}}.
}
\description{
This is the main function for performing MCMC BSL and MCMC BSLasso.
Parallel computing is supported with the R package \code{foreach}.
}
\references{
An, Z., South, L. F., Nott, D. J. &  Drovandi, C. C. (2018). Accelerating
Bayesian synthetic likelihood with the graphical lasso. \url{https://eprints.qut.edu.au/102263/}

Price, L. F., Drovandi, C. C., Lee, A., & Nott, D. J. (2018).
Bayesian synthetic likelihood. To appear in Journal of Computational and Graphical Statistics.
\url{https://eprints.qut.edu.au/92795/}
}
\seealso{
\code{\link{selectPenalty}} for a function to tune the BSLasso tuning parameter
and \code{\link{plot}} for functions related to visualisation.
}
\author{
Ziwen An, Christopher C. Drovandi and Leah F. South
}
