% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BTLLasso-package.R
\docType{data}
\name{GLESsmall}
\alias{GLESsmall}
\title{Subset of the GLES data set with 200 observations and 4 covariates.}
\format{A list containing data from the German Longitudinal Election Study with 200 observations. 
The list contains both information on the response (paired comparisons) and different covariates.
\describe{ 
\item{Y}{A response.BTLLasso object for the GLES data including
\itemize{
\item{response: Ordinal paired comparison response vector} 
\item{first.object: Vector containing the first-named party per paired comparison}
\item{second.object: Vector containing the second-named party per paired comparison}
\item{subject: Vector containing a person identifier per paired comparison}
}}
\item{X}{Matrix containing all eight person-specific covariates
\itemize{
\item{Age: Age in years} 
\item{Gender (0: male, 1: female)}
}
}
\item{Z1}{Matrix containing all four person-party-specific covariates
\itemize{
\item{Climate: Self-perceived distance of each person to all five parties with respect to 
ones attitude towards climate change.}
\item{Immigration: Self-perceived distance of each person to all five parties with respect to 
ones attitude towards immigration.}
}
}
}}
\source{
\url{http://gles.eu/wordpress/english/}
}
\description{
This is a subset of the \code{\link{GLES}} data set from the German
Longitudinal Election Study (GLES), see Rattinger et al. (2014). The subset contains 
only 200 of the 2003 observations and only  a small part of the covariates. The GLES is
a long-term study of the German electoral process. It collects pre- and
post-election data for several federal elections, the data used here
originate from the pre-election study for 2013.
}
\examples{

\dontrun{
data(GLESsmall)

## extract data and center covariates for better interpretability
Y <- GLESsmall$Y
X <- scale(GLESsmall$X, scale = FALSE)
Z1 <- scale(GLESsmall$Z1, scale = FALSE)

## vector of subtitles, containing the coding of the X covariates
subs.X <- c("", "female (1); male (0)")

## vector of tuning parameters
lambda <- exp(seq(log(61), log(1), length = 30)) - 1


## compute BTLLasso model 
m.gles <- BTLLasso(Y = Y, X = X, Z1 = Z1, lambda = lambda)
print(m.gles)

singlepaths(m.gles, x.axis = "loglambda", subs.X = subs.X)
paths(m.gles, y.axis = "L2")

## Cross-validate BTLLasso model 
m.gles.cv <- cv.BTLLasso(Y = Y, X = X, Z1 = Z1, lambda = lambda)
print(m.gles.cv)

singlepaths(m.gles.cv, subs.X = subs.X)
}

}
\references{
Rattinger, H., S. Rossteutscher, R. Schmitt-Beck, B. Wessels,
and C. Wolf (2014): Pre-election cross section (GLES 2013). \emph{GESIS Data
Archive, Cologne ZA5700 Data file Version 2.0.0.}

Schauberger, Gunther and Tutz, Gerhard (2015): Modelling
Heterogeneity in Paired Comparison Data - an L1 Penalty Approach with an
Application to Party Preference Data, \emph{Department of Statistics, LMU
Munich}, Technical Report 183

Schauberger, Gunther, Groll Andreas and Tutz, Gerhard (2016): Modelling 
Football Results in the German Bundesliga Using Match-specific Covariates, 
\emph{Department of Statistics, LMU Munich}, Technical Report 197
}
\keyword{datasets}

