% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgnbd.R
\name{bgnbd.pmf.General}
\alias{bgnbd.pmf.General}
\title{Generalized BG/NBD Probability Mass Function}
\usage{
bgnbd.pmf.General(params, t.start, t.end, x)
}
\arguments{
\item{params}{BG/NBD parameters - a vector with r, alpha, a, and b, in that
order. r and alpha are unobserved parameters for the NBD transaction
process. a and b are unobserved parameters for the Beta geometric dropout
process.}

\item{t.start}{start of time period for which probability is being
calculated. It can also be a vector of values.}

\item{t.end}{end of time period for which probability is being calculated.
It can also be a vector of values.}

\item{x}{number of repeat transactions by a random customer in the period
defined by (t.start, t.end]. It can also be a vector of values.}
}
\value{
Probability of x transaction occuring between t.start and t.end
conditional on model parameters. If t.start, t.end, and/or x has a length
greater than one, a vector of probabilities will be returned.
}
\description{
Generalized probability mass function for the BG/NBD.
}
\details{
P(X(t.start, t.end)=x | r, alpha, a, b). Returns the probability that a
customer makes x repeat transactions in the time interval (t.start, t.end].

It is impossible for a customer to make a negative number of repeat
transactions. This function will return an error if it is given negative
times or a negative number of repeat transactions. This function will also
return an error if t.end is less than t.start.

t.start, t.end, and x may be vectors. The standard rules for vector
operations apply - if they are not of the same length, shorter vectors will
be recycled (start over at the first element) until they are as long as the
longest vector. It is advisable to keep vectors to the same length and to use
single values for parameters that are to be the same for all calculations. If
one of these parameters has a length greater than one, the output will be a
vector of probabilities.
}
\examples{
params <- c(0.243, 4.414, 0.793, 2.426)
# probability that a customer will make 10 repeat transactions in the
# time interval (1,2]
bgnbd.pmf.General(params, t.start=1, t.end=2, x=10)
# probability that a customer will make no repeat transactions in the
# time interval (39,78]
bgnbd.pmf.General(params, t.start=39, t.end=78, x=0)
}
\references{
Fader, Peter S.; Hardie, Bruce G.S.and Lee, Ka Lok. “Computing
P(alive) Using the BG/NBD Model.” December. 2008.
\href{http://www.brucehardie.com/notes/021/palive_for_BGNBD.pdf}{Web.}
}
