% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgnbd.R
\name{bgnbd.Expectation}
\alias{bgnbd.Expectation}
\title{BG/NBD Expectation}
\usage{
bgnbd.Expectation(params, t, hardie = TRUE)
}
\arguments{
\item{params}{BG/NBD parameters - a vector with r, alpha, a, and b, in that
order. r and alpha are unobserved parameters for the NBD transaction
process. a and b are unobserved parameters for the Beta geometric dropout
process.}

\item{t}{length of time for which we are calculating the expected number of
repeat transactions.}

\item{hardie}{if TRUE, use \code{\link{h2f1}} instead of
\code{\link[hypergeo]{hypergeo}}.}
}
\value{
Number of repeat transactions a customer is expected to make in a
time period of length t.
}
\description{
Returns the number of repeat transactions that a randomly chosen customer
(for whom we have no prior information) is expected to make in a given time
period.
}
\details{
E(X(t) | r, alpha, a, b)
}
\examples{
params <- c(0.243, 4.414, 0.793, 2.426)

# Number of repeat transactions a customer is expected to make in 2 time intervals.
bgnbd.Expectation(params, t=2, hardie = FALSE)

# We can also compare expected transactions over time:
bgnbd.Expectation(params, t=1:10)
}
\references{
Fader, Peter S.; Hardie, Bruce G.S.and Lee, Ka Lok. “Computing
P(alive) Using the BG/NBD Model.” December. 2008. Web.
\url{http://www.brucehardie.com/notes/021/palive_for_BGNBD.pdf}
}
\seealso{
\code{\link{bgnbd.ConditionalExpectedTransactions}}
}
