% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/90_method.R, R/95_method_fcast.R,
%   R/96_method_irf.R
\name{print.bvar}
\alias{print.bvar}
\alias{print.bv_fcast}
\alias{print.bvar_fcast}
\alias{print.bv_irf}
\alias{print.bvar_irf}
\title{BVAR print methods}
\usage{
\method{print}{bvar}(x, ...)

\method{print}{bv_fcast}(x, ...)

\method{print}{bvar_fcast}(x, ...)

\method{print}{bv_irf}(x, ...)

\method{print}{bvar_irf}(x, ...)
}
\arguments{
\item{x}{A \code{bvar} / \code{bvar_...} object, obtained from
\code{\link{bvar}} or related functions.}

\item{...}{Not used.}
}
\description{
Print methods for \code{bvar} objects providing a quick overview of results.
The method for impulse response functions provides information on
identification, horizon, et cetera; The forecast method on the horizon.
}
\examples{
\donttest{
data <- matrix(rnorm(200), ncol = 2)
x <- bvar(data, lags = 2)

# Print various output generated
print(x)
}
}
