% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/91_plot.R
\name{plot.bvar}
\alias{plot.bvar}
\title{Plotting method for Bayesian VARs}
\usage{
\method{plot}{bvar}(
  x,
  type = c("full", "trace", "density", "irf", "fcast"),
  vars = NULL,
  vars_response = NULL,
  vars_impulse = NULL,
  chains = list(),
  mar = c(2, 2, 2, 0.5),
  ...
)
}
\arguments{
\item{x}{A \code{bvar} object, obtained from \code{\link{bvar}}.}

\item{type}{A string with the type of plot desired. The default option
\code{"full"} plots both densities and traces.}

\item{vars}{Character vector used to select variables. Elements are matched
to hyperparameters or coefficients. Coefficients may be matched based on
the dependent variable (by providing the name or position) or the
explanatory variables (by providing the name and the desired lag). See the
example section for a demonstration. Defaults to \code{NULL}, i.e. all
hyperparameters.}

\item{vars_response, vars_impulse}{Optional character or integer vectors used
to select coefficents. Dependent variables are specified with
\emph{vars_response}, explanatory ones with \emph{vars_impulse}. See the
example section for a demonstration.}

\item{chains}{List of \code{bvar} objects. Contents are then added to trace
and density plots to help assessing covergence.}

\item{mar}{Numeric vector. Margins for \code{\link[graphics]{par}}.}

\item{...}{Other graphical parameters for \code{\link[graphics]{par}}.}
}
\value{
Returns \emph{x} invisibly.
}
\description{
Method to plot trace and densities of coefficient, hyperparameter and
marginalised draws obtained from \code{\link{bvar}}. Several types of plot
are available via the argument \emph{type}, including traces, densities,
plots of forecasts and impulse responses.
}
\examples{
\donttest{
# Access a subset of the fred_qd dataset
data <- fred_qd[, c("CPIAUCSL", "UNRATE", "FEDFUNDS")]
# Transform it to be stationary
data <- fred_transform(data, codes = c(5, 5, 1), lag = 4)

# Estimate a BVAR using one lag, default settings and very few draws
x <- bvar(data, lags = 1, n_draw = 1000L, n_burn = 200L, verbose = FALSE)

# Plot full traces and densities
plot(x)

# Only plot the marginalised likelihood's trace
plot(x, "trace", "ml")

# Access IRF and forecast plotting functions
plot(x, type = "irf", vars_response = 2)
plot(x, type = "fcast", vars = 2)
}
}
\seealso{
\code{\link{bvar}}; \code{\link{plot.bvar_fcast}};
\code{\link{plot.bvar_irf}}.
}
\keyword{BVAR}
\keyword{MCMC}
\keyword{analysis}
\keyword{plot}
