% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernelize.R
\name{kernelize}
\alias{kernelize}
\title{Transform a matrix of input data into a matrix of kernel simmilarities values}
\usage{
kernelize(m1, m2 = NA, s = 1)
}
\arguments{
\item{m1}{matrix on samples X features to compute kernels on}

\item{m2}{matrix of samples X features to compute kernels with respect to.}

\item{s}{numeric multiplier of standard deviation for the Gaussian kernels (default:1).}
}
\value{
matrix of similarities between rows of m1 and rows of m2.
}
\description{
The input matrices should have samples as the rows and features as columns. A kernel will 
computed across all samples in the first matrix with respect to the samples in the second matrix.
The two matrices must have the same features. If all features are binary 0,1, then
the Jaccard similarity kernel will be used, otherwise, a Gaussian kernel with standard deviation
equal to s times the mean distances between samples.
}
\examples{
m1 <- matrix(rnorm(200), 8, 25, dimnames=list(paste0('sample.', 1:8), paste0('feat.', 1:25)))
m2 <- matrix(rnorm(100), 4, 25, dimnames=list(paste0('sample.', 9:12), paste0('feat.', 1:25)))
kernelize(m1, m1)
kernelize(m1, m1, s=.5)
kernelize(m2, m1)
}

