% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_Tucker.R
\name{test_Tucker}
\alias{test_Tucker}
\title{Perform 'cold start' prediction for Tucker models}
\usage{
test_Tucker(d, m)
}
\arguments{
\item{d}{an input data object created with \code{input_data}}

\item{m}{a \code{Tucker_model} object created with \code{mk_model}}
}
\value{
Response tensor generated by multiplying the input data through the trained model
}
\description{
Perform 'cold start' prediction for Tucker models
}
\examples{
data.params <- get_data_params(c('decomp=Tucker'))
toy <- mk_toy(data.params)
train.data <- input_data$new(mode1.X=toy$mode1.X[,-1],
                             mode2.X=toy$mode2.X[,-1],
                             mode3.X=toy$mode3.X[,-1],
                             resp=toy$resp)
model.params <- get_model_params(c('decomp=Tucker'))
toy.model <- mk_model(train.data, model.params)
toy.model$rand_init(model.params)

resp <- test_Tucker(train.data, toy.model)
}

