% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Organism.R
\docType{methods}
\name{optimizeLP}
\alias{optimizeLP}
\alias{optimizeLP,Organism-method}
\title{Function for computing the linear programming according to the model structure}
\usage{
optimizeLP(object, lpob = object@lpobj, lb = object@lbnd,
  ub = object@ubnd)

\S4method{optimizeLP}{Organism}(object, lpob = object@lpobj,
  lb = object@lbnd, ub = object@ubnd)
}
\arguments{
\item{object}{An object of class Organisms.}

\item{lpob}{A linear programing object encoding the problem to solve.}

\item{lb}{A numeric vector giving the constraint values of lower bounds.}

\item{ub}{A numeric vector giving the constraint values of upper bounds.}
}
\description{
The generic function \code{optimizeLP} implements a linear programming based on the problem structure and refined constraints.
}
\details{
The problem object \code{lpob} is modified according to the constraints and then solved with \code{optimizeProb}.
}
\examples{
data(Ec_core, envir = environment()) #get Escherichia coli core metabolic model
org <- Organism(Ec_core,deathrate=0.05,
           growthlimit=0.05,growtype="exponential") #initialize a organism
optimizeLP(org)
}
\seealso{
\code{\link{Organism-class}}, \code{\link{optimizeProb}} and \code{\link{sysBiolAlg}}
}

