% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arena.R
\docType{methods}
\name{plotTotFlux}
\alias{plotTotFlux}
\alias{plotTotFlux,Eval-method}
\title{Function for plotting the overall change in reaction activity}
\usage{
plotTotFlux(object, legendpos = "topright", num = 20)

\S4method{plotTotFlux}{Eval}(object, legendpos = "topright", num = 20)
}
\arguments{
\item{object}{An object of class Eval.}

\item{legendpos}{A character variable declaring the position of the legend}

\item{num}{An integer defining the number of substrates to be plot}
}
\description{
The generic function \code{plotTotFlux} plots the time course of reactions with high variation in activity for an \code{Eval} object.
}
\examples{
data(Ec_core, envir = environment()) #get Escherichia coli core metabolic model
bac <- Bac(Ec_core,deathrate=0.05,
           minweight=0.05,growtype="exponential") #initialize a bacterium
arena <- Arena(n=20,m=20) #initialize the environment
arena <- addOrg(arena,bac,amount=10) #add 10 organisms
arena <- addSubs(arena,40) #add all possible substances
eval <- simEnv(arena,5)
plotTotFlux(eval)
}

