% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Organism.R
\name{simBac_par}
\alias{simBac_par}
\alias{simBac_par,Bac-method}
\title{Function for one simulation iteration for objects of Bac class}
\usage{
simBac_par(
  object,
  arena,
  j,
  sublb,
  bacnum,
  lpobject,
  sec_obj = "none",
  cutoff = 1e-06,
  with_shadow = FALSE
)

\S4method{simBac_par}{Bac}(
  object,
  arena,
  j,
  sublb,
  bacnum,
  lpobject,
  sec_obj = "none",
  cutoff = 1e-06,
  with_shadow = FALSE
)
}
\arguments{
\item{object}{An object of class Bac.}

\item{arena}{An object of class Arena defining the environment.}

\item{j}{The index of the organism of interest in orgdat.}

\item{sublb}{A vector containing the substance concentrations in the current position of the individual of interest.}

\item{bacnum}{integer indicating the number of bacteria individuals per gridcell}

\item{lpobject}{linar programming object (copy of organism@lpobj) that have to be a deep copy in parallel due to pointer use in sybil.}

\item{sec_obj}{character giving the secondary objective for a bi-level LP if wanted.}

\item{cutoff}{value used to define numeric accuracy}

\item{with_shadow}{True if shadow cost should be stores (default off).}
}
\value{
Returns the updated enivironment of the \code{population} parameter with all new positions of individuals on the grid and all new substrate concentrations.
}
\description{
The generic function \code{simBac_par} implements all neccessary functions for the individuals to update the complete environment.
}
