% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Organism.R
\name{consume}
\alias{consume}
\alias{consume,Organism-method}
\title{Function to account for the consumption and production of substances}
\usage{
consume(object, sublb, cutoff = 1e-06, bacnum, fbasol)

\S4method{consume}{Organism}(object, sublb, cutoff = 1e-06, bacnum, fbasol)
}
\arguments{
\item{object}{An object of class Organisms.}

\item{sublb}{A vector containing the substance concentrations in the current position of the individual of interest.}

\item{cutoff}{A number giving the cutoff value by which value of objective function is considered greater than 0.}

\item{bacnum}{Integer indicating the number of bacteria individuals per gridcell}

\item{fbasol}{Problem object according to the constraints and then solved with \code{optimizeProb}.}
}
\value{
Returns the updated vector containing the substance concentrations in the current position of the individual of interest.
}
\description{
The generic function \code{consume} implements the consumption and production of substances based on the flux of exchange reactions of organisms
}
\details{
The consumption is implemented by adding the flux of the exchange reactions to the current substance concentrations.
}
\examples{
NULL
}
\seealso{
\code{\link{Organism-class}}
}
