% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Organism.R
\docType{methods}
\name{chemotaxis}
\alias{chemotaxis}
\alias{chemotaxis,Bac-method}
\title{Function for chemotaxis of bacteria to their prefered substrate}
\usage{
chemotaxis(object, population, j, chemo, occupyM)

\S4method{chemotaxis}{Bac}(object, population, j, chemo, occupyM)
}
\arguments{
\item{object}{An object of class Bac.}

\item{population}{An object of class Arena.}

\item{j}{The number of the iteration of interest.}

\item{chemo}{The vector that contains the prefered substrate.}

\item{occupyM}{A matrix indicating grid cells that are obstacles}
}
\description{
The generic function \code{chemotaxis} implements a bacterial movement in the Moore neighbourhood to the highest substrate concentration.
}
\details{
Bacteria move to a position in the Moore neighbourhood which has the highest concentration of the prefered substrate, which is not occupied by other individuals. The prefered substance is given by slot \code{chem} in the \code{Bac} object. If there is no free space the individuals stays in the same position. If the concentration in the Moore neighbourhood has the same concentration in every position, then random movement is implemented.
}
\examples{
data(Ec_core, envir = environment()) #get Escherichia coli core metabolic model
bac <- Bac(Ec_core,deathrate=0.05, chem = "EX_o2(e)",
           minweight=0.05,growtype="exponential") #initialize a bacterium
arena <- Arena(n=20,m=20) #initialize the environment
arena <- addOrg(arena,bac,amount=10) #add 10 organisms
arena <- addSubs(arena,40) #add all possible substances
chemotaxis(bac,arena,1, "EX_glc(e)", arena@occupyM)
}
\seealso{
\code{\link{Bac-class}} and \code{\link{emptyHood}}
}
