% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arena.R
\docType{methods}
\name{getCorrM}
\alias{getCorrM}
\alias{getCorrM,Eval-method}
\title{Function to compute and return correlation matrix}
\usage{
getCorrM(object, reactions = TRUE, bacs = TRUE, substrates = TRUE)

\S4method{getCorrM}{Eval}(object, reactions = TRUE, bacs = TRUE,
  substrates = TRUE)
}
\arguments{
\item{object}{An object of class Eval.}

\item{reactions}{A boolean indicating whether reactions should be included in correlation matrix}

\item{bacs}{A boolean indicating whether bacteria should be included in correlation matrix}

\item{substrates}{A boolean indicating whether substrates should be included in correlation matrix}
}
\value{
correlation matrix
}
\description{
The generic function \code{getCorrM} returns the correlation matrix of several objects.
}
\details{
Returns correlation matrix which can be used for statistical analysis
}
\examples{
data(Ec_core, envir = environment()) #get Escherichia coli core metabolic model
bac <- Bac(Ec_core,deathrate=0.05,
           minweight=0.05,growtype="exponential") #initialize a bacterium
arena <- Arena(n=20,m=20) #initialize the environment
arena <- addOrg(arena,bac,amount=10) #add 10 organisms
arena <- addSubs(arena,40) #add all possible substances
eval <- simEnv(arena,5)
getCorrM(eval)
}
\seealso{
\code{\link{Eval-class}}
}
