% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hlpm2.R
\name{hlpm2}
\alias{hlpm2}
\title{Hierarchical Local Pivotal Method 2}
\usage{
hlpm2(prob, x, sizes, type = "kdtree2", bucketSize = 50, eps = 1e-12)
}
\arguments{
\item{prob}{A vector of length N with inclusion probabilities.}

\item{x}{An N by p matrix of (standardized) auxiliary variables. Squared euclidean distance is used in the \code{x} space.}

\item{sizes}{A vector of integers containing the sizes of the subsamples.
\code{sum(sizes) = sum(prob)} must hold.}

\item{type}{The method used in finding nearest neighbours.
Must be one of \code{"kdtree0"}, \code{"kdtree1"}, \code{"kdtree2"}, and
\code{"notree"}.}

\item{bucketSize}{The maximum size of the terminal nodes in the k-d-trees.}

\item{eps}{A small value used to determine when an updated probability is
close enough to 0.0 or 1.0.}
}
\value{
A vector of selected indices in 1,2,...,N.

A matrix with the population indices of the combined sample in the
first column, and the associated subsample in the second column.
}
\description{
Selects an initial sample using the \code{\link[=lpm2]{lpm2()}}, and then splits this sample into
subsamples of given \code{sizes} using successive, hierarchical selection with
the \code{\link[=lpm2]{lpm2()}}.
The method is used to select several subsamples, such that each subsample, and
the combination (i.e. the union of all subsamples), is spatially balanced.
}
\details{
The inclusion probabilities \code{prob} \emph{must} sum to an integer n.
The sizes of the subsamples \code{sum(sizes)} \emph{must} sum to the same integer n.
}
\section{k-d-trees}{

The \code{type}s "kdtree" creates k-d-trees with terminal node bucket sizes
according to \code{bucketSize}.

\itemize{
\item{"kdtree0"} creates a k-d-tree using a median split on alternating variables.
\item{"kdtree1"} creates a k-d-tree using a median split on the largest range.
\item{"kdtree2"} creates a k-d-tree using a sliding-midpoint split.
\item{"notree"} does a naive search for the nearest neighbour.
}
}

\examples{
\dontrun{
set.seed(12345);
N = 1000;
n = 100;
prob = rep(n/N, N);
x = matrix(runif(N * 2), ncol = 2);
sizes = c(10, 20, 30, 40);
s = hlpm2(prob, x, sizes);
plot(x[, 1], x[, 2]);
points(x[s, 1], x[s, 2], pch = 19);
}

}
\references{
Friedman, J. H., Bentley, J. L., & Finkel, R. A. (1977).
An algorithm for finding best matches in logarithmic expected time.
ACM Transactions on Mathematical Software (TOMS), 3(3), 209-226.

Maneewongvatana, S., & Mount, D. M. (1999, December).
It’s okay to be skinny, if your friends are fat.
In Center for geometric computing 4th annual workshop on computational geometry (Vol. 2, pp. 1-8).

Grafström, A., Lundström, N.L.P. & Schelin, L. (2012).
Spatially balanced sampling through the Pivotal method.
Biometrics 68(2), 514-520.

Lisic, J. J., & Cruze, N. B. (2016, June).
Local pivotal methods for large surveys.
In Proceedings of the Fifth International Conference on Establishment Surveys.
}
\seealso{
Other sampling: 
\code{\link{cube}()},
\code{\link{lcube}()},
\code{\link{lpm}()},
\code{\link{scps}()}
}
\concept{sampling}
