% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhdist.R
\name{nhdist}
\alias{nhdist}
\title{Distance Matrix Computation for Non-Hilbert Data}
\usage{
nhdist(x, method = "geodesic")
}
\arguments{
\item{x}{a numeric matrix, data frame or numeric array of dimension \eqn{k \times m \times n} 
containing \eqn{n} samples in \eqn{k \times m} dimension.}

\item{method}{the distance measure to be used. This must be one of "geodesic", "compositional", "riemann". 
Any unambiguous substring can be given.}
}
\value{
\eqn{n \times n} numeric distance matrix
}
\description{
This function computes and returns the numeric distance matrix 
computed by using the specified distance measure to compute 
the distances between the rows of a data matrix.
}
\details{
Available distance measures are geodesic, compositional and riemann.
Denoting any two sample in the dataset as \eqn{x} and \eqn{y}, 
we give the definition of distance measures as follows.

geodesic:

The shortest route between two points on the Earth's surface, namely, a segment of a great circle.
\deqn{acos(x^{T}y), \|x\|_{2} = \|y\|_{2} = 1}

compositional:

First, we apply scale transformation to it, i.e., \eqn{(x_{i1}/t, ..., x_{ip}/t_{i}), t_{i} = \sum_{d=1}^{p}{x_{d}}} 
. Then, apply the square root transformation to data and calculate the geodesic distance between samples.

riemann:

\eqn{k \times m \times n} array where \eqn{k} = number of landmarks, \eqn{m} = number of dimensions and \eqn{n} = sample size. Detail about
riemannian shape distance was given in Kendall, D. G. (1984).
}
\examples{
data('bdvmf')
Dmat <- nhdist(bdvmf[['x']], method = "geodesic")

data("ArcticLake")
Dmat <- nhdist(ArcticLake[['x']], method = "compositional")

data("macaques")
Dmat <- nhdist(macaques[["x"]], method = "riemann")

# unambiguous substring also available:
Dmat <- nhdist(macaques[["x"]], method = "rie")

}
\references{
Kendall, D. G. (1984). Shape manifolds, Procrustean metrics and complex projective spaces, Bulletin of the London Mathematical Society, 16, 81-121.
}
