% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bartModelMatrix.R
\name{bartModelMatrix}
\alias{bartModelMatrix}
\title{Create a matrix out of a vector or data frame}
\usage{
bartModelMatrix(
  X,
  numcut = 0L,
  usequants = FALSE,
  type = 7,
  rm.const = FALSE,
  cont = FALSE,
  xinfo = NULL
)
}
\arguments{
\item{X}{A vector or data frame where the matrix is created.}

\item{numcut}{The maximum number of cut points to consider. If \code{numcut=0}, then return a matrix; otherwise, return a list
containing a matrix \code{X}, a vector \code{numcut} and a list \code{xinfo}.}

\item{usequants}{A Boolean argument indicating the way to generate cut points. If \code{usequants=FALSE}, then the cut points 
in \code{xinfo} are generated uniformly; otherwise, the quantiles are used for the cut points.}

\item{type}{An integer between \eqn{1} and \eqn{9} determining which algorithm is employed in the function \code{quantile()}.}

\item{rm.const}{A Boolean argument indicating whether to remove constant variables.}

\item{cont}{A Boolean argument indicating whether to assume all variables are continuous.}

\item{xinfo}{A list (matrix) where the items (rows) are the predictors and the contents (columns) of the items are the cut points.
If \code{xinfo=NULL}, BART will choose \code{xinfo} for the user.}
}
\value{
The function \code{bartModelMatrix()} returns a list with the following components.
\item{X}{A matrix with rows corresponding to observations and columns corresponding to predictors (after dummification).}
\item{numcut}{A vector of \code{ncol(X)} integers with each indicating the number of cut points for the corresponding predictor.}
\item{rm.const}{A vector of indicators for the predictors (after dummification) used in BART; when the indicator is negative, 
it refers to remove that predictor.}
\item{xinfo}{A list (matrix) where the items (rows) are the predictors and the contents (columns) of the items are the cut points.}
\item{grp}{A vector of group indices for predictors. For example, if \eqn{2} appears \eqn{3} times in \code{grp}, the second 
predictor of \code{X} is a categorical predictor with \eqn{3} levels.}
}
\description{
The external BART functions (e.g. \code{wbart()}) operate on matrices in memory. Therefore, if the user submits a vector or 
data frame, then this function converts it to a matrix. Also, it determines the number of cut points necessary for each column
when asked to do so. This function is inherited from the CRAN package 'BART'.
}
\examples{
 
## simulate data (Scenario C.M.1. in Luo and Daniels (2021))
set.seed(123)
data = mixone(100, 10, 1, FALSE)
## test bartModelMatrix() function
res = bartModelMatrix(data$X, numcut=100, usequants=FALSE, cont=FALSE, rm.const=TRUE)
}
\references{
Chipman, H. A., George, E. I. and McCulloch, R. E. (2010). 
  "BART: Bayesian additive regression trees."
   \emph{Ann. Appl. Stat.} \strong{4} 266--298.
   
Linero, A. R. (2018). 
  "Bayesian regression trees for high-dimensional prediction and variable selection." 
  \emph{J. Amer. Statist. Assoc.} \strong{113} 626--636.

Luo, C. and Daniels, M. J. (2021)
  "Variable Selection Using Bayesian Additive Regression Trees."
  \emph{arXiv preprint arXiv:2112.13998}.
  
Rockova V, Saha E (2019). 
  “On theory for BART.” 
  \emph{In The 22nd International Conference on Artificial Intelligence and Statistics} (pp. 2839–2848). PMLR.
  
Sparapani, R., Spanbauer, C. and McCulloch, R. (2021).
  "Nonparametric machine learning and efficient computation with bayesian additive regression trees: the BART R package."
  \emph{J. Stat. Softw.} \strong{97} 1--66.
}
\seealso{
\code{\link{wbart}} and \code{\link{pbart}}.
}
\author{
Chuji Luo: \email{cjluo@ufl.edu} and Michael J. Daniels: \email{daniels@ufl.edu}.
}
