% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kclustering.R
\name{kclustering}
\alias{kclustering}
\title{K-means  cluster analysis}
\usage{
kclustering(
  data,
  k = NULL,
  labels = NULL,
  nclumax = 10,
  nruns = 10,
  iter.max = 50,
  algorithm = "Hartigan-Wong"
)
}
\arguments{
\item{data}{numeric data frame.}

\item{k}{integer, number of clusters.}

\item{labels}{character, row labels.}

\item{nclumax}{integer, maximum number of clusters (when \code{k=NULL}) used for calculating the explained variance as function of the number of clusters.}

\item{nruns}{integer, run the k-means algorithm \code{nruns} times and chooses the best solution according to a maximum explained variance criterion.}

\item{iter.max}{integer, maximum number of iterations allowed in k-means clustering (see \link[stats]{kmeans}).}

\item{algorithm}{character, the algorithm used in k-means clustering (see \link[stats]{kmeans}).}
}
\value{
A \code{kclustering} object.

If \code{k} is \code{NULL}, the \code{kclustering} object is a list of 3 elements:

\itemize{
\item \code{k} \code{NULL}
}

\itemize{
\item \code{clusterRange} integer vector, values of \code{k} (from 1 to \code{nclumax}) at which the \emph{variance between} of the clusterization is evaluated
}

\itemize{
\item \code{VarianceBetween} numeric vector, values of the \emph{variance between} evaluated for \code{k} in \code{clusterRange}
}

If \code{k} is not \code{NULL}, the \code{kclustering} object is a list of 4 elements:

\itemize{
\item \code{k} integer, number of clusters
}

\itemize{
\item \code{Subjects} data frame, subjects' cluster identifiers
}

\itemize{
\item \code{ClusterList} list, clusters' composition
}

\itemize{
\item \code{Profiles} data frame, clusters' profiles, i.e. the average of the variables within clusters and the cluster eterogeineity index (\code{CHI})
}
}
\description{
K-means  cluster analysis
}
\details{
The \code{kclustering} function performs a preliminary standardization of columns in \code{data}.
}
\examples{
FF <- fourfactors(Tbox,Obox)
X <- with(FF, data.frame(OD.Rtg=ORtg/DRtg,
               F1.r=F1.Def/F1.Off, F2.r=F2.Off/F2.Def,
               F3.O=F3.Def, F3.D=F3.Off))
X$P3M <- Tbox$P3M
X$STL.r <- Tbox$STL/Obox$STL
kclu1 <- kclustering(X)
plot(kclu1)
kclu2 <- kclustering(X, k=9)
plot(kclu2)
}
\references{
P. Zuccolotto and M. Manisera (2020) Basketball Data Science: With Applications in R. CRC Press.
}
\seealso{
\code{\link{plot.kclustering}}, \code{\link[stats]{kmeans}}
}
\author{
Marco Sandri, Paola Zuccolotto, Marica Manisera (\email{basketballanalyzer.help@unibs.it})
}
