% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.outcross2.R
\name{read.outcross2}
\alias{read.outcross2}
\title{Read data from a full-sib progeny (outcrossing populations)}
\usage{
read.outcross2(infile)
}
\arguments{
\item{infile}{the name of the input file which contains the data to be read.}
}
\value{
An object of class \code{outcross}, i.e., a list with the following
components: \item{geno}{a matrix with integers indicating the genotypes
read for each marker. Each column contains data for a marker and each row
represents an individual.} \item{n.ind}{number of individuals.}
\item{n.mar}{number of markers.} \item{segr.type}{a vector with the
segregation type of each marker, as \code{strings}.} \item{segr.type.num}{a
vector with the segregation type of each marker, represented in a
simplified manner as integers, i.e. 1 corresponds to markers of type
\code{"A"}; 2 corresponds to markers of type \code{"B1.5"}; 3 corresponds
to markers of type \code{"B2.6"}; 4 corresponds to markers of type
\code{"B3.7"}; 5 corresponds to markers of type \code{"C.8"}; 6 corresponds
to markers of type \code{"D1"} and 7 corresponds to markers of type
\code{"D2"}} \item{n.phe}{the number of traits included in the file}
\item{pheno}{the name of the phenoytpes} \item{input}{the name of the input file.}
}
\description{
This version implements the \code{read.outcross} function in a faster
way. Everything else is essentially the same.
}
\examples{
\dontrun{
    outcr_data <-
read.outcross2("data_file.txt")
  }
}
\references{
Broman, K. W., Wu, H., Churchill, G., Sen, S., Yandell, B.
(2008) \emph{qtl: Tools for analyzing QTL experiments} R package version
1.09-43

Lincoln, S. E., Daly, M. J. and Lander, E. S. (1993) Constructing genetic
linkage maps with MAPMAKER/EXP Version 3.0: a tutorial and reference
manual. \emph{A Whitehead Institute for Biomedical Research Technical
Report}.

Wu, R., Ma, C.-X., Painter, I. and Zeng, Z.-B. (2002) Simultaneous maximum
likelihood estimation of linkage and linkage phases in outcrossing species.
\emph{Theoretical Population Biology} 61: 349-363.
}
\seealso{
\code{example} directory in the package source.
}
\author{
Adapted from Karl Broman (package \pkg{qtl}) by Gabriel R A
Margarido, \email{gramarga@gmail.com}, later with additions from Luciano C Silva
}
\keyword{IO}
