% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogNormalCode.R
\name{genlognormaldata}
\alias{genlognormaldata}
\title{Generating function for Lognormal Data.}
\usage{
genlognormaldata(sample_size, mu1, mean_ratio, common_sd, censor_value)
}
\arguments{
\item{sample_size}{Number of subjects per arm.}

\item{mu1}{meanlog parameter used in call to \code{rlnorm()}.
Used only in control arm.}

\item{mean_ratio}{Desired Mean Ratio between experimental and control groups.}

\item{common_sd}{sdlog parameter used in call to \code{rlnorm()}.
Used in both arms.}

\item{censor_value}{Value at which time-to-event data are right censored.}
}
\value{
\code{genlognormaldata()} returns a data frame with columns: 'id', 'treatment',
  'event_time', and 'status'.
}
\description{
\code{genlognormaldata()} function used mainly internally by
\code{lognormaltrialsimulator()} and \code{lognormaltrialsimulatornohist()} functions
to generate data for a two-arm clinical trial, experimental and control groups.
Can be used to generate random trial data.
}
\examples{
samplehistdata <- genlognormaldata(sample_size=60, mu1=1.06, mean_ratio=0.6,
                                   common_sd=1.25, censor_value=3)
samplehistdata
}
