% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputs.R
\name{coef.BayesFBHborrow}
\alias{coef.BayesFBHborrow}
\title{Extract mean posterior values}
\usage{
\method{coef}{BayesFBHborrow}(object, ...)
}
\arguments{
\item{object}{MCMC sample object from BayesFBHborrow()}

\item{...}{other arguments, see coef.default()}
}
\value{
mean values of given samples
}
\description{
S3 method for class "BayesFBHborrow", returns the mean posterior values
for the fixed parameters
}
\examples{
data(weibull_cc, package = "BayesFBHborrow")

# Set your tuning parameters
tuning_parameters <- list("Jmax" = 5,
                          "pi_b" = 0.5,
                          "cprop_beta" = 0.5)
                          
# run the MCMC sampler
out <- BayesFBHborrow(weibull_cc, NULL, tuning_parameters = tuning_parameters,
                      iter = 3, warmup_iter = 1)

# Plot the posterior mean values of the fixed parameters
coef(out$out)
}
