% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{smc_mallows_new_item_rank_alpha_fixed}
\alias{smc_mallows_new_item_rank_alpha_fixed}
\title{SMC-Mallows new item rank (alpha fixed)}
\usage{
smc_mallows_new_item_rank_alpha_fixed(
  alpha,
  n_items,
  R_obs,
  metric,
  leap_size,
  N,
  Time,
  logz_estimate,
  mcmc_kernel_app,
  alpha_prop_sd,
  lambda,
  alpha_max,
  aug_method,
  verbose = FALSE
)
}
\arguments{
\item{alpha}{A numeric value of the true scale parameter}

\item{n_items}{Integer is the number of items in a ranking}

\item{R_obs}{3D matrix of size n_assessors by n_items by Time containing a set of observed rankings of Time time steps}

\item{metric}{A character string specifying the distance metric to use in the
Bayesian Mallows Model. Available options are \code{"footrule"},
\code{"spearman"}, \code{"cayley"}, \code{"hamming"}, \code{"kendall"}, and
\code{"ulam"}.}

\item{leap_size}{leap_size Integer specifying the step size of the leap-and-shift
proposal distribution}

\item{N}{Integer specifying the number of particles}

\item{Time}{Integer specifying the number of time steps in the SMC algorithm}

\item{logz_estimate}{Estimate of the partition function, computed with
\code{\link{estimate_partition_function}} in the BayesMallow R package {estimate_partition_function}.}

\item{mcmc_kernel_app}{Integer value for the number of applications we apply the MCMC move kernel}

\item{alpha_prop_sd}{Numeric value specifying the standard deviation of the
lognormal proposal distribution used for \eqn{\alpha} in the
Metropolis-Hastings algorithm. Defaults to \code{0.1}.}

\item{lambda}{Strictly positive numeric value specifying the rate parameter
of the truncated exponential prior distribution of \eqn{\alpha}. Defaults
to \code{0.1}. When \code{n_cluster > 1}, each mixture component
\eqn{\alpha_{c}} has the same prior distribution.}

\item{alpha_max}{Maximum value of \code{alpha} in the truncated exponential
prior distribution.}

\item{aug_method}{A character string specifying the approach for filling in
the missing data, options are "pseudolikelihood" or "random".}

\item{verbose}{Logical specifying whether to print out the progress of the
SMC-Mallows algorithm. Defaults to \code{FALSE}.}
}
\value{
a 3d matrix containing the samples of rho and alpha from the SMC algorithm
}
\description{
Function to perform resample-move SMC algorithm where we receive a new item ranks from an existing user
at each time step. Each correction and augmentation is done by filling in the missing item ranks randomly.
}
