% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heat_plot.R
\name{heat_plot}
\alias{heat_plot}
\title{Heat plot of posterior probabilities}
\usage{
heat_plot(model_fit, burnin = model_fit$burnin, ...)
}
\arguments{
\item{model_fit}{An object of type \code{BayesMallows}, returned from
\code{\link{compute_mallows}}.}

\item{burnin}{A numeric value specifying the number of iterations
to discard as burn-in. Defaults to \code{x$burnin}, and must be
provided if \code{x$burnin} does not exist. See \code{\link{assess_convergence}}.}

\item{...}{Additional arguments passed on to other methods. In particular,
\code{type = "CP"} or \code{type = "MAP"} can be passed on to
\code{\link{compute_consensus}} to determine the order of items along the
horizontal axis.}
}
\value{
A ggplot object.
}
\description{
Generates a heat plot with items in their consensus ordering along the
horizontal axis and ranking along the vertical axis. The color denotes
posterior probability.
}
\examples{
# Setting the number of Monte Carlo samples very low for the example to run fast.
# A real application should run much longer, and have a large burnin.
model_fit <- compute_mallows(potato_visual, nmc = 500, seed = 1)
model_fit$burnin <- 100

heat_plot(model_fit)

# Items are ordered along the horizontal axis according to the ordering
# returned by compute_consensus, whose default argument is type="CP".

heat_plot(model_fit, type = "MAP")
}
