% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssEst.R
\name{ssEst}
\alias{ssEst}
\title{Steady State Estimate}
\usage{
ssEst(y, BTE = c(100, 1000, 1), stationary = FALSE)
}
\arguments{
\item{y}{Vector of mass flow rate observations.  Must be specified sequentially with \code{y[1]} as the initial observation.}

\item{BTE}{Numeric vector giving \code{c(Burn-in, Total-iterations, and Every)} for MCMC approximation of target distributions. The function \code{BMB} produces a total number of samples of \eqn{(T - B)/E}.  \eqn{E} specifies that only one of every \eqn{E} draws are saved. \eqn{E > 1} reduces autocorrelation between obtained samples at the expense of computation time.}

\item{stationary}{Logical indicating if stationarity will be imposed when generating posterior draws.  See Details.}
}
\value{
Returns a list of outputs

\item{\code{samples}}{List of vectors containing posterior draws of model parameters}

\item{\code{stationary}}{Logical indicating the setting of the \code{stationary} argument provided to the \code{ssEst} function}

\item{\code{y}}{Vector of observations initially passed to the \code{ssEst} function.}

\item{\code{type}}{Character string giving details of the model fit.  Primarily included for use with \code{\link{plot.BayesMassBal}}}
}
\description{
Allows for the estimation of process steady state of a single stream for a process using flow rate data.
}
\details{
The model of the following form is fit to the data:

\deqn{y_t = \mu + \alpha y_{t-1} + \epsilon}

Where \eqn{\epsilon \sim \mathcal{N}(0,\sigma^2)} and \eqn{t} indexes the time step.

A time series is stationary, and predictable, when \eqn{|\alpha|< 1}.  Stationarity can be enforced, using the argument setting \code{stationary = TRUE}.  This setting utilizes the priors \eqn{p(\alpha) \sim \mathcal{N}}(0, 1000) truncated at (-1,1), and \eqn{p(\mu) \sim \mathcal{N}}(0, \code{var(y)*100}) for inference, producing a posterior distribution for \eqn{\alpha} constrained to be within (-1,1).

When fitting a model where stationarity is not enforced, the Jeffreys prior of \eqn{p(\mu,\alpha)\propto 1} is used.

The Jeffreys prior of \eqn{p(\sigma^2)\propto 1/\sigma^2} is used for all inference of \eqn{\sigma^2}

A stationary time series will have an expected value of:

\deqn{\frac{\mu}{1-\alpha}}

Samples of this expectation are included in the output if \code{stationary = TRUE} or if none of the samples of \eqn{\alpha} lie outside of (-1,1).

The output list is a \code{BMB} object, passing the output to \code{\link{plot.BayesMassBal}} allows for observation of the results.
}
\examples{

## Generating Data
y <- rep(NA, times = 21)

y[1] <- 0
mu <- 3
alpha <- 0.3
sig <- 2
for(i in 2:21){
 y[i] <- mu + alpha*y[i-1] + rnorm(1)*sig
}

## Generating draws of model parameters

fit <- ssEst(y, BTE = c(100,500,1))

}
