% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qx_ci.R
\name{qx_ci}
\alias{qx_ci}
\title{Predictive intervals for deaths probabilities.}
\usage{
qx_ci(fit, age = NULL, Ex = NULL, prob = 0.95)
}
\arguments{
\item{fit}{Object of the following classes: 'HP', 'DLM', 'ClosedHP', or 'ClosedDLM'.}

\item{age}{Vector with the ages to compute the predictive intervals.}

\item{Ex}{Vector with the exposures of the selected ages. Its length must be equal to the age vector. This argument is only necessary when using the Poisson and the Binomial distributions.}

\item{prob}{Coverage probability of the predictive intervals.}
}
\value{
A data.frame object with the selected ages and the respective predictive intervals of the death probabilities.
}
\description{
This function returns the predictive intervals for death probabilities of a
mortality graduation provide by hp(), dlm(), hp_close() or dlm_close() functions
}
\examples{
## Importing mortality data from the USA available on the Human Mortality Database (HMD):
data(USA)

## Selecting the exposure and the death count of the year 2000, ranging from 0 to 90 years old:
USA2000 = USA[USA$Year == 2000,]
x = 0:90
Ex = USA2000$Ex.Total[x+1]
Dx = USA2000$Dx.Total[x+1]

## Fitting poisson HP model and DLM:
fit = hp(x = x, Ex = Ex, Dx = Dx, model = "poisson",
         M = 1000, bn = 0, thin = 10)

## predictive intervals
qx_ci(fit)
qx_ci(fit, age = 0:110, Ex = USA2000$Ex.Total, prob=0.99)

}
