% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNGP.R
\name{dmnorm_nngp}
\alias{dmnorm_nngp}
\title{Function for the evaluating the NNGP approximate density.}
\usage{
dmnorm_nngp(x, mean, AD, nID, N, k, log)
}
\arguments{
\item{x}{N-vector of data.}

\item{mean}{N-vector with current values of the mean}

\item{AD}{N x (k+1) matrix; the first k columns are the 'A' matrix, and the
last column is the 'D' vector.}

\item{nID}{N x k matrix of neighbor indices.}

\item{N}{Scalar; number of data measurements.}

\item{k}{Scalar; number of nearest neighbors.}

\item{log}{Scalar; should the density be on the log scale (1) or not (0).}
}
\value{
The NNGP approximate density.
}
\description{
\code{dmnorm_nngp} (and \code{rmnorm_nngp}) calculate the approximate NNGP
likelihood for a fixed set of parameters (i.e., A and D matrices). Finally,
the distributions must be registered within \code{nimble}.
}
