% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{nsCrossdist}
\alias{nsCrossdist}
\title{Calculate coordinate-specific cross-distance matrices}
\usage{
nsCrossdist(coords, Pcoords, scale_factor = NULL, isotropic = FALSE)
}
\arguments{
\item{coords}{N x 2 matrix; contains x-y coordinates of station (observed)
locations.}

\item{Pcoords}{M x 2 matrix; contains x-y coordinates of prediction
locations.}

\item{scale_factor}{Scalar; optional argument for re-scaling the distances.}

\item{isotropic}{Logical; indicates whether distances should be calculated
using Euclidean distance (\code{isotropic = TRUE}) or using the anisotropic
formulation (\code{isotropic = FALSE}).}
}
\value{
A list of distances matrices, with the following components:
\item{dist1_sq}{M x N matrix; contains values of pairwise squared cross-
distances in the x-coordinate.}
\item{dist2_sq}{M x N matrix; contains values of pairwise squared cross-
distances in the y-coordinate.}
\item{dist12}{M x N matrix; contains values of pairwise signed cross-
distances between the x- and y-coordinates.}
\item{scale_factor}{Value of the scale factor used to rescale distances.}
}
\description{
\code{nsCrossdist} calculates coordinate-specific cross distances in x, y,
and x-y for use in the nonstationary cross-correlation calculation. This 
function is useful for calculating posterior predictions.
}
\examples{
# Generate some coordinates 
coords <- cbind(runif(100),runif(100))
Pcoords <- cbind(runif(200),runif(200))
# Calculate distances
Xdist_list <- nsCrossdist(coords, Pcoords)

}
