% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F1_ComputeKLDs.R
\name{ComputeKLDs}
\alias{ComputeKLDs}
\title{Compute signed and symmetric Kullback-Leibler divergence}
\usage{
ComputeKLDs(tree, var0, vars, seq, pbar = TRUE, method = "gaussian")
}
\arguments{
\item{tree}{a \code{\linkS4class{ClusterTree}} object}

\item{var0}{the variable to have evidence absrobed}

\item{vars}{the variables to have divergence computed}

\item{seq}{a \code{vector} of numeric values as the evidences}

\item{pbar}{\code{logical(1)} whether to show progress bar}

\item{method}{method for divergence computation:
\code{gaussian} for Gaussian approximation, \code{} for Monte Carlo integration}
}
\value{
a \code{data.frame} of the divergence
}
\description{
Compute signed and symmetric Kullback-Leibler divergence of variables over a spectrum of evidence
}
\details{
Compute signed and symmetric Kullback-Leibler divergence of variables over a spectrum of evidence.
The signed and symmetric Kullback-Leibler divergence is also known as Jeffery's signed information (JSI) for
continuous variables.
}
\examples{
\dontrun{
data(liver)
tree.init.p <- Initializer(dag=liver$dag, data=liver$data,
                           node.class=liver$node.class,
                           propagate = TRUE)
klds <- ComputeKLDs(tree=tree.init.p, var0="Nr1i3",
                    vars=setdiff(tree.init.p@node, "Nr1i3"),
                    seq=seq(-3,3,0.5))
head(klds)
}
}
\references{
Cowell, R. G. (2005). Local propagation in conditional Gaussian Bayesian networks.
Journal of Machine Learning Research, 6(Sep), 1517-1550. \cr
\cr
Yu H, Moharil J, Blair RH (2020). BayesNetBP: An R Package for Probabilistic Reasoning in Bayesian
Networks. Journal of Statistical Software, 94(3), 1-31. <doi:10.18637/jss.v094.i03>.
}
\author{
Han Yu
}
