# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title BayesSUR_internal
#' @description
#' Run a SUR Bayesian sampler -- internal function
#' @name BayesSUR_internal
#' @param dataFile path to data file
#' @param outFilePath path to where the output is to be written
#' @param nIter number of iterations
#' @param nChains number of parallel chains to run
#'
#' NOTE THAT THIS IS BASICALLY JUST A WRAPPER
NULL

BayesSUR_internal <- function(dataFile, mrfGFile, blockFile, structureGraphFile, hyperParFile, outFilePath, nIter = 10L, burnin = 0L, nChains = 1L, covariancePrior = "HIW", gammaPrior = "hotspot", gammaSampler = "bandit", gammaInit = "MLE", betaPrior = "independent", maxThreads = 2L, output_gamma = TRUE, output_beta = TRUE, output_Gy = TRUE, output_sigmaRho = TRUE, output_pi = TRUE, output_tail = TRUE, output_model_size = TRUE, output_CPO = TRUE, output_model_visit = FALSE) {
    .Call('_BayesSUR_BayesSUR_internal', PACKAGE = 'BayesSUR', dataFile, mrfGFile, blockFile, structureGraphFile, hyperParFile, outFilePath, nIter, burnin, nChains, covariancePrior, gammaPrior, gammaSampler, gammaInit, betaPrior, maxThreads, output_gamma, output_beta, output_Gy, output_sigmaRho, output_pi, output_tail, output_model_size, output_CPO, output_model_visit)
}

randU01 <- function() {
    .Call('_BayesSUR_randU01', PACKAGE = 'BayesSUR')
}

randLogU01 <- function() {
    .Call('_BayesSUR_randLogU01', PACKAGE = 'BayesSUR')
}

randIntUniform <- function(a, b) {
    .Call('_BayesSUR_randIntUniform', PACKAGE = 'BayesSUR', a, b)
}

randExponential <- function(lambda) {
    .Call('_BayesSUR_randExponential', PACKAGE = 'BayesSUR', lambda)
}

randVecExponential <- function(n, lambda) {
    .Call('_BayesSUR_randVecExponential', PACKAGE = 'BayesSUR', n, lambda)
}

randBinomial <- function(n, p) {
    .Call('_BayesSUR_randBinomial', PACKAGE = 'BayesSUR', n, p)
}

randMultinomial <- function(n, prob) {
    .Call('_BayesSUR_randMultinomial', PACKAGE = 'BayesSUR', n, prob)
}

randNormal <- function(m = 0., sigmaSquare = 1.) {
    .Call('_BayesSUR_randNormal', PACKAGE = 'BayesSUR', m, sigmaSquare)
}

randVecNormal <- function(n, m = 0., sigmaSquare = 1.) {
    .Call('_BayesSUR_randVecNormal', PACKAGE = 'BayesSUR', n, m, sigmaSquare)
}

randT <- function(nu) {
    .Call('_BayesSUR_randT', PACKAGE = 'BayesSUR', nu)
}

randVecT <- function(n, nu) {
    .Call('_BayesSUR_randVecT', PACKAGE = 'BayesSUR', n, nu)
}

randMvT <- function(nu, m, Sigma) {
    .Call('_BayesSUR_randMvT', PACKAGE = 'BayesSUR', nu, m, Sigma)
}

randGamma <- function(shape, scale) {
    .Call('_BayesSUR_randGamma', PACKAGE = 'BayesSUR', shape, scale)
}

randIGamma <- function(shape, scale) {
    .Call('_BayesSUR_randIGamma', PACKAGE = 'BayesSUR', shape, scale)
}

randWishart <- function(df, S) {
    .Call('_BayesSUR_randWishart', PACKAGE = 'BayesSUR', df, S)
}

randBeta <- function(a, b) {
    .Call('_BayesSUR_randBeta', PACKAGE = 'BayesSUR', a, b)
}

randBernoulli <- function(pi) {
    .Call('_BayesSUR_randBernoulli', PACKAGE = 'BayesSUR', pi)
}

