% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptspec.R
\name{adaptspec}
\alias{adaptspec}
\title{Adaptive Spectral Estimation for Non-stationary Time Series}
\usage{
adaptspec(nloop, nwarmup, nexp_max, x,
   tmin, sigmasqalpha, tau_prior_a, tau_prior_b,
   tau_up_limit, prob_mm1, step_size_max,
   var_inflate, nbasis, nfreq_hat, plotting)
}
\arguments{
\item{nloop}{The total number of MCMC iterations}

\item{nwarmup}{The number of burn-in iterations}

\item{nexp_max}{The maximum number of segments allowed}

\item{x}{The data, a univariate time series, not a time series object}

\item{tmin}{The minimum number of observations per segment. An optional argument defaulted to tmin = 40.}

\item{sigmasqalpha}{An optional argument defaulted to sigmasqalpha = 100.}

\item{tau_prior_a}{An optional argurment defaulted to tau_prior_a = -1.}

\item{tau_prior_b}{An optional argurment defaulted to tau_prior_b = 0.}

\item{tau_up_limit}{An optional argurment defaulted to tau_up_limit = 10000.}

\item{prob_mm1}{An optional argurment defaulted to prob_mm1 = 0.8.}

\item{step_size_max}{An optional argurment defaulted to step_size_max = 10.}

\item{var_inflate}{An optional argurment defaulted to var_inflate = 1.}

\item{nbasis}{An optional argurment defaulted to nbasis = 7.}

\item{nfreq_hat}{An optional argurment defaulted to nfreq_hat = 50.}

\item{plotting}{An optional argument for displaying output plots defaulted to FALSE. When set to TRUE, this displays the spectral and parition points.}
}
\value{
xi The partition points

log_spec_hat Estimates of the log spectra for all segments

nexp_curr The number of segments in each iteration.
}
\description{
Methodology for analyzing possibly non-stationary time series by adaptively dividing the time series into an unknown but finite number of segments and estimating the corresponding local spectra by smoothing splines.
}
\examples{
#Running adaptspec with the simulated_piecewise data.
data(simulated_piecewise)
model1 <- adaptspec(nloop = 80, nwarmup = 20,
   nexp_max = 5, x = simulated_piecewise[1:100])
str(model1)
summary(model1$nexp_curr)
plot(model1$nexp_curr)

}
\references{
Rosen, O., Wood, S. and Stoffer, D. (2012). AdaptSPEC: Adaptive Spectral Estimation for Nonstationary Time Series. J. of the American Statistical Association, 107, 1575-1589
}
\author{
Rosen, O., Wood, S. and Stoffer, D.
}
