% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JAGS-marglik.R
\name{JAGS_bridgesampling}
\alias{JAGS_bridgesampling}
\title{Compute marginal likelihood of a 'JAGS' model}
\usage{
JAGS_bridgesampling(
  fit,
  data,
  prior_list,
  log_posterior,
  add_parameters = NULL,
  add_bounds = NULL,
  maxiter = 10000,
  silent = TRUE,
  ...
)
}
\arguments{
\item{fit}{model fitted with either \link[runjags]{runjags} posterior
samples obtained with \link[rjags]{rjags-package}}

\item{data}{data that were used to fit the model}

\item{prior_list}{named list of prior distribution
(names correspond to the parameter names)}

\item{log_posterior}{function that takes a named list of samples, the data,
and additional list of parameters passed as \code{...} as input and
returns the log of the unnormalized posterior density of the model part}

\item{add_parameters}{vector of additional parameter names that should be used
in bridgesampling but were not specified in the \code{prior_list}}

\item{add_bounds}{list with two name vectors (\code{"lb"} and \code{"up"})
containing lower and upper bounds of the additional parameters that were not
specified in the \code{prior_list}}

\item{maxiter}{maximum number of iterations for the
\link[bridgesampling]{bridge_sampler}}

\item{silent}{whether the progress should be printed, defaults to \code{TRUE}}

\item{...}{additional argument to the \link[bridgesampling]{bridge_sampler}
and \code{log_posterior} function}
}
\value{
\code{JAGS_bridgesampling} returns an object of class 'bridge'.
}
\description{
A wrapper around
\link[bridgesampling]{bridge_sampler} that automatically
computes likelihood part dependent on the prior distribution
and prepares parameter samples. \code{log_posterior} must
specify a function that takes two arguments - a named list
of samples from the prior distributions and the data, and returns
log likelihood of the model part.
}
\examples{
# simulate data
set.seed(1)
data <- list(
  x = rnorm(10),
  N = 10
)
data$x

# define priors
priors_list <- list(mu = prior("normal", list(0, 1)))

# define likelihood for the data
model_syntax <-
  "model{
    for(i in 1:N){
      x[i] ~ dnorm(mu, 1)
    }
  }"

# fit the models
fit <- JAGS_fit(model_syntax, data, priors_list, chains = 1, sample = 1000, seed = 0)

# define log posterior for bridge sampling
log_posterior <- function(parameters, data){
  sum(dnorm(data$x, parameters$mu, 1, log = TRUE))
}

# get marginal likelihoods
marglik <- JAGS_bridgesampling(fit, data, priors_list, log_posterior)

}
