% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors-plot.R
\name{plot.prior}
\alias{plot.prior}
\title{Plots a prior object}
\usage{
\method{plot}{prior}(
  x,
  plot_type = "base",
  x_seq = NULL,
  xlim = NULL,
  x_range_quant = NULL,
  n_points = 1000,
  n_samples = 10000,
  force_samples = FALSE,
  transformation = NULL,
  transformation_arguments = NULL,
  transformation_settings = FALSE,
  show_figures = if (individual) -1 else NULL,
  individual = FALSE,
  rescale_x = FALSE,
  par_name = NULL,
  ...
)
}
\arguments{
\item{x}{a prior}

\item{plot_type}{whether to use a base plot \code{"base"}
or ggplot2 \code{"ggplot2"} for plotting. The later
requires \pkg{ggplot2} package to be installed.}

\item{x_seq}{sequence of x coordinates}

\item{xlim}{x plotting range}

\item{x_range_quant}{quantile used for
automatically obtaining \code{x_range}
if both \code{x_range} and \code{x_seq}
are unspecified. Defaults to \code{0.005}
for all but Cauchy, Student-t, Gamma, and
Inverse-gamme distributions that use
\code{0.010}.}

\item{n_points}{number of equally spaced points
in the \code{x_range} if \code{x_seq} is unspecified}

\item{n_samples}{number of samples from the prior
distribution if the density cannot be obtained
analytically (or if samples are forced with
\code{force_samples = TRUE})}

\item{force_samples}{should prior be sampled instead
of obtaining analytic solution whenever possible}

\item{transformation}{transformation to be applied
to the prior distribution. Either a character
specifying one of the prepared transformations:
\describe{
\item{lin}{linear transformation in form of \code{a + b*x}}
\item{tanh}{also known as Fisher's z transformation}
\item{exp}{exponential transformation}
}, or a list containing the transformation function \code{fun},
inverse transformation function \code{inv}, and the Jacobian of
the transformation \code{jac}. See examples for details.}

\item{transformation_arguments}{a list with named arguments for
the \code{transformation}}

\item{transformation_settings}{boolean indicating whether the
settings the \code{x_seq} or \code{x_range} was specified on
the transformed support}

\item{show_figures}{which figures should be returned in case of
multiple plots are generated. Useful when priors for the omega
parameter are plotted and \code{individual = TRUE}.}

\item{individual}{should individual densities be returned
(e.g., in case of weightfunction)}

\item{rescale_x}{allows to rescale x-axis in case a
weightfunction is plotted.}

\item{par_name}{a type of parameter for which the prior is
specified. Only relevant if the prior corresponds to a mu
parameter that needs to be transformed.}

\item{...}{additional arguments}
}
\value{
\code{plot.prior} returns either \code{NULL} or
an object of class 'ggplot' if plot_type is \code{plot_type = "ggplot"}.
}
\description{
Plots a prior object
}
\examples{
# create some prior distributions
p0 <- prior(distribution = "point",  parameters = list(location = 0))
p1 <- prior(distribution = "normal", parameters = list(mean = 0, sd = 1))
p2 <- prior(distribution = "normal", parameters = list(mean = 0, sd = 1), truncation = list(0, Inf))

# a default plot
plot(p0)

# manipulate line thickness and color, change the parameter name
plot(p1, lwd = 2, col = "blue", par_name = bquote(mu))

# use ggplot
plot(p2, plot_type = "ggplot")

# utilize the ggplot prior geom
plot(p2, plot_type = "ggplot", xlim = c(-2, 2)) + geom_prior(p1, col = "red", lty = 2)

# apply transformation
plot(p1, transformation = "exp")

}
\seealso{
\code{\link[=prior]{prior()}} \code{\link[=lines.prior]{lines.prior()}}  \code{\link[=geom_prior]{geom_prior()}}
}
