% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary-tables.R
\name{BayesTools_ensemble_tables}
\alias{BayesTools_ensemble_tables}
\alias{ensemble_estimates_table}
\alias{ensemble_inference_table}
\alias{ensemble_summary_table}
\alias{ensemble_diagnostics_table}
\title{Create BayesTools ensemble summary tables}
\usage{
ensemble_estimates_table(
  samples,
  parameters,
  probs = c(0.025, 0.95),
  title = NULL,
  footnotes = NULL,
  warnings = NULL,
  transform_orthonormal = FALSE,
  formula_prefix = TRUE
)

ensemble_inference_table(
  inference,
  parameters,
  logBF = FALSE,
  BF01 = FALSE,
  title = NULL,
  footnotes = NULL,
  warnings = NULL
)

ensemble_summary_table(
  models,
  parameters,
  logBF = FALSE,
  BF01 = FALSE,
  title = NULL,
  footnotes = NULL,
  warnings = NULL,
  remove_spike_0 = TRUE,
  short_name = FALSE
)

ensemble_diagnostics_table(
  models,
  parameters,
  title = NULL,
  footnotes = NULL,
  warnings = NULL,
  remove_spike_0 = TRUE,
  short_name = FALSE
)
}
\arguments{
\item{samples}{posterior samples created by \link{mix_posteriors}}

\item{parameters}{character vector of parameters (or a
named list with of character vectors for summary and
diagnostics tables) specifying the parameters
(and their grouping) for the summary table}

\item{probs}{quantiles for parameter estimates}

\item{title}{title to be added to the table}

\item{footnotes}{footnotes to be added to the table}

\item{warnings}{warnings to be added to the table}

\item{transform_orthonormal}{whether factors with orthonormal prior
distributions should be transformed to differences from the grand
mean}

\item{formula_prefix}{whether the parameter prefix from formula should
be printed. Defaults to \code{TRUE}.}

\item{inference}{model inference created by \link{ensemble_inference}}

\item{logBF}{whether the Bayes factor should be on log scale}

\item{BF01}{whether the Bayes factor should be inverted}

\item{models}{list of \link{models_inference} model objects,
each of which containing a list of \code{priors}
and \code{inference} object, The \code{inference} must be a
named list with information about the model: model number
\code{m_number}, marginal likelihood \code{marglik}, prior and
posterior probability \code{prior_prob} and \code{post_prob},
inclusion Bayes factor \code{inclusion_BF}, and fit summary
generated by \link{runjags_estimates_table} for the diagnostics
table}

\item{remove_spike_0}{whether prior distributions equal to spike
at 0 should be removed from the \code{prior_list}}

\item{short_name}{whether the prior distribution names should be
shortened. Defaults to \code{FALSE}.}
}
\value{
\code{ensemble_estimates_table} returns a table with the
model-averaged estimates, \code{ensemble_inference_table} returns
a table with the prior and posterior probabilities and inclusion
Bayes factors, \code{ensemble_summary_table} returns a table with
overview of the models included in the ensemble, and
\code{ensemble_diagnostics_table} returns an overview of the MCMC
diagnostics for the models included in the ensemble. All of the
tables are objects of class 'BayesTools_table'.
}
\description{
Creates estimate summaries based on posterior
distributions created by \link{mix_posteriors}, inference summaries
based on inference created by \link{ensemble_inference}, or ensemble
summary/diagnostics based on a list of \link{models_inference} models.
}
\seealso{
\link{ensemble_inference} \link{mix_posteriors} \link{BayesTools_model_tables}
}
