% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata_to_fit_MRMC.R
\name{metadata_to_fit_MRMC}
\alias{metadata_to_fit_MRMC}
\title{Create metadata for MRMC data}
\usage{
metadata_to_fit_MRMC(dataList)
}
\arguments{
\item{dataList}{it should include  \code{m,q,c,h,f,NL,C,M,Q} which means from the right

\code{m } means the modality ID vector

\code{q } means the reader ID vector

\code{c } means the confidence level

\code{h } means the number of hits

\code{f } means the number of false alarm

\code{NL } means the Total number of lesions for all images

\code{C } means the highest number of confidence level

\code{M } means the number of modalities

\code{Q } means the number of readers.

The detail of these dataset, please see the endowed datasets.
Note that the maximal number of confidence  level, denoted by  \code{C}, are included,
however,
its each confidence level should not included  your data. So, to confirm
your false positives and hits are correctly correspondence
to confidence levels,
you should confirm the orders by the function \code{viewdata_MRMC}.}
}
\value{
A metadata such as number of cumulative false alarms and hits to create and draw the curve.
}
\description{
From data of number of hits and false alarms, we calculate the number of cumulative false positives and hits.
Since there are three subscripts, reader, modality, and image, we create array format and vector format etc...
}
\examples{
\donttest{
#First, we prepare the data endowed with this package.

        dat  <- get(data("dataList.Chakra.Web"))




#Second, we run the stan funtion
#with data named "dat"  and the author's Bayesian model.


             metadata_to_fit_MRMC(dat)






#Now, we get a metadata.

}# dottest

}
