% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document_dataset_srsc.R
\docType{data}
\name{dataList.divergent.transition.in.case.of.srsc}
\alias{dataList.divergent.transition.in.case.of.srsc}
\title{An FROC Dataset with \strong{\emph{Divergent Transitions}} in case of A Single reader and A Single modality}
\format{
A list consists of the following
  integer vectors  \code{f, h} and integers \code{NL, NI, C}.


\describe{
\item{ \code{f}  }{Non-negative integer vector  specifying  number of false alarms   associated with  each confidence level. The first component corresponding to the highest confidence level.}
\item{ \code{h}  }{Non-negative integer vector  specifying  number  of Hits  associated with  each confidence level. The first component corresponding to the highest confidence level.}
\item{ \code{NL} }{A positive integer, representing  Number of Lesions.}
\item{ \code{NI} }{A positive integer, representing  Number of Images. }
\item{ \code{C}  }{A positive integer, representing  Number of Confidence level. }
}




\strong{\emph{Contents:}}

 \emph{ A single reader and single modality case   }




------------------------------------------------------------------------------------------------------
\tabular{rccc}{
\code{NI=57,NL=269}   \tab \strong{ confidence level } \tab \strong{ No. of false alarms} \tab \strong{No. of hits}  \cr
 In R console ->      \tab \code{ c} \tab   \code{f }  \tab   \code{h}  \cr
  -----------------------\tab ----------------------- \tab ----------------------------- \tab ------------- \cr
\emph{\strong{definitely present}}  \tab  3 \tab 0 \tab     21\cr
 probably present                   \tab  2 \tab 7 \tab    4\cr
 questionable                       \tab  1 \tab 36 \tab   3\cr
 }

---------------------------------------------------------------------------------------------------


*  \emph{false alarms} = False Positives = FP

*  \emph{hits} = True Positives = TP

Note that  in FROC data, the confidence level means present (deseased, positive) case only. Since each reader marks their suspicous location only and it generate the hits and false alarms for his confidenc level representing that lesion is present.
In the absent case, reader does not mark any locations and hence, the absent cofidence level does not relate this dataset.


Note that the first column of confidence level vector \code{c } should not be specified. If specified, will be ignored , since it is created by \code{  c <-c(rep(C:1))} automatically in the program and it does not refer from user input data even if it is specified explicitly, where \code{C} is the highest number of confidence levels.
So you should check the compatibility of your data and the program's generating new confidence  level vector by
a table which can be displayed by the function \code{\link{viewdata}()}.


Note that The format for the above example data must be made by the following forms:


\code{ dat <- list(                      }

\code{   c=c(3,2,1),    #Confidence level}

\code{   h=c(21,4,3), #Number of hits for each confidence level}

 \code{  f=c(0,7,36),  #Number of false alarms for each confidence level}

\code{   NL=60,       #Number of lesions}

 \code{  NI=30,        #Number of images}

\code{   C=3)          #Number of confidence level    }

This \R object \code{dat} can be passed to the function \code{\link{fit_Bayesian_FROC}()}  as the following manner \code{fit_Bayesian_FROC(dat)}.
}
\description{
A list, representing an  FROC dataset with \strong{divergent transitions }.

Note that the maximal number of confidence level,
denoted by  \code{C}, are included,
however,  confidence level vector \code{c } should not be specified.
 If specified, will be ignored ,
 since it is created by \code{  c <-c(rep(C:1))} in the program
 and it does not refer from user input data,
 where \code{C} is the highest number of confidence levels.
Should write down your hits and
false alarms vector so that it is compatible with this automatically created  vector \code{c}.
}
\examples{
\dontrun{
#========================================================================================
#  Change the zero cell to 1,
#  then The number of divergent transitions are significantly decrease
#  Thus, the divergent transtions is not rigid.
#========================================================================================

data   <- dataList.divergent.transition.in.case.of.srsc
data$f <- c(1,7,36)
f      <- fit_Bayesian_FROC( ite  = 1111,  cha = 1, summary = TRUE, dataList = data )


}#dontrun


}
