% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/validation_MRMC_Create_dataList_MRMC_Hit_from_rate_etc.R
\name{hits_creator_from_rate}
\alias{hits_creator_from_rate}
\title{MRMC Dataset Creator From Hit Rate.}
\usage{
hits_creator_from_rate(NL = 252, seed = 123, p.truth = BayesianFROC::p_truth)
}
\arguments{
\item{NL}{Number of Lesions.}

\item{seed}{The seed for creating data consisting of the number of hits synthesized by the binomial distributions with the specified seed.}

\item{p.truth}{Array of dimension (C, M, Q), where
C = number of confidence levels,
M = number of modalities,
Q = number of readers.}
}
\value{
Hits Data, an \code{array of dimension [Confidence, Modality, Reader]}.
}
\description{
From hit rates, data of hits are created.
}
\details{
Random variables of hits are distributed as follows.

     \deqn{h_{5,m,r} \sim Binomial (p_{5,m,r}, N_L ),}

then \eqn{h_{4,m,r}} should be drawn from the binomial distribution with remaining targets

     \deqn{h_{4,m,r} \sim Binomial (\frac{p_{4,m,r}}{1-p_{5,m,r}}, N_L - h_{5,m,r}).}

Similarly,

     \deqn{h_{3,m,r} \sim Binomial (\frac{p_{3,m,r}}{1-p_{5,m,r}-p_{4,m,r}}, N_L - h_{5,m,r} -h_{4,m,r}).}

     \deqn{h_{2,m,r} \sim Binomial (\frac{p_{2,m,r}}{1-p_{5,m,r}-p_{4,m,r}-p_{3,m,r}}, N_L - h_{5,m,r} -h_{4,m,r}-h_{3,m,r}).}

     \deqn{h_{1,m,r} \sim Binomial (\frac{p_{1,m,r}}{1-p_{5,m,r}-p_{4,m,r}-p_{3,m,r}-p_{2,m,r}}, N_L - h_{5,m,r} -h_{4,m,r}-h_{3,m,r}-h_{2,m,r}).}





    \code{p.truth}  is an array representing \eqn{p_{c,m,r}}.
    Specifying the array \code{p.truth} ( and hence \eqn{p_{c,m,r}} ),
    with the above model,
    we can calculate hit data \eqn{h_{c,m,r}} for each \eqn{c,m,r}.
}
\examples{
\dontrun{
#========================================================================================
#2019 Sept 6 1)    Using the default hit values, hit data are created as follows;
#========================================================================================


           hits <- hits_creator_from_rate()








#========================================================================================
#2019 Sept 6 2)   If user want to use their own hit rates, then use the following codes:
#========================================================================================



 h <- hits_creator_from_rate(

  NL=252,
  seed =123,
  p.truth =
   array(c(
     c(0.03,0.13,0.2,0.3,0.4,   #for M=1 Q=1
       0.04,0.23,0.3,0.4,0.5) , #for M=2 Q=1 ,

     c(0.05,0.33,0.4,0.5,0.6,   #for M=1 Q=2
       0.06,0.43,0.5,0.6,0.7)  ,#for M=2 Q=2 ,

     c(0.07,0.53,0.6,0.7,0.8,   #for M=1 Q=3
       0.08,0.63,0.7,0.8,0.9)   #for M=2 Q=3 ,
       ),

  dim = c(5,2,3) #C M Q
  )#array

)






#========================================================================================
#2019 Sept 6 3)   If user want to use their own hit rates, then use the following codes:
#========================================================================================







 h <- hits_creator_from_rate(

  NL=252,
  seed =123,
  p.truth =
   array(c(

     c(0.03,0.1,0.2,0.3,0.4,   #for M=1 Q=1
       0.04,0.2,0.3,0.4,0.5,   #for M=2 Q=1
       0.05,0.3,0.4,0.5,0.6),  #for M=3 Q=1

     c(0.05,0.33,0.4,0.5,0.6,   #for M=1 Q=2
       0.06,0.43,0.5,0.6,0.7,   #for M=2 Q=2
       0.05,0.3,0.4,0.5,0.6),   #for M=3 Q=2

     c(0.07,0.53,0.6,0.7,0.8,   #for M=1 Q=3
       0.08,0.63,0.7,0.8,0.9,   #for M=2 Q=3
       0.05,0.3,0.4,0.5,0.6)    #for M=3 Q=3

       ),

  dim = c(5,3,3) #C M Q

  )#array

)






#========================================================================================
#2019 Sept 6 3)   Only one reader
#========================================================================================



 h <- hits_creator_from_rate(

  NL=252,
  seed =123,
  p.truth =
   array(c(

     c(0.03,0.1,0.2,0.3,0.4,   #for M=1 Q=1
       0.04,0.2,0.3,0.4,0.5,   #for M=2 Q=1
       0.05,0.3,0.4,0.5,0.6)   #for M=3 Q=1

       ),

  dim = c(5,3,1) #C M Q

  )#array

)




#========================================================================================
#
#========================================================================================

#================The third example======================================

#     The hits rate cannot take any values, since there is a trend that a hit rate of
#   a higher confidence level is a higher. So, If it is difficult for user to create
#   a true hit rates, then  by taking estimates as true parameters,
#   user can replicate datasets.
#     To do so, work follow is first fitting, secondly extracting estimates,
#   thirdly apply this function (hits_creator_from_rate() ).


# * Fitting

     fit <- fit_Bayesian_FROC(
             dataList.Chakra.Web.orderd,
             ite = 1111,  #  For simplicity, we take small MCMC samples.
             summary =FALSE)

# * Extracting

        estimates <- extract_estimates_MRMC(fit)

         ppp <- estimates$ppp.EAP

#      Note that ppp is an array
#     whose dimension is constituted by number of confidence levels, modalities, readers.


# *  Replicating as an true values is ppp


        hits  <-   hits_creator_from_rate(p.truth = ppp )


# <<Remark>>
#     ppp is an array.  ignoring its indices, we can write that

#          hits ~ Binomial(ppp, NL)

#    Where NL is a number of lesions.

#   By writing its component explicitly, we can write

#        Hits[c,m,r] ~ Binomial(ppp[c,m,r], NL)

#        Where c means the c-th confidence level,
#              m  means the m-th modality,
#              r means the r-th reader.
}# dottest
}
