% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argMax.R
\name{name_of_param_whose_Rhat_is_maximal}
\alias{name_of_param_whose_Rhat_is_maximal}
\title{Extract a name of parameter from StanfitExtended object (or stanfit object.)}
\usage{
name_of_param_whose_Rhat_is_maximal(StanS4class)
}
\arguments{
\item{StanS4class}{An S4 object of class \emph{\code{ \link{stanfitExtended}}} which is an inherited class from the S4 class  \code{stanfit}.
This \R object is a fitted model object
 as a return value of the function \code{\link{fit_Bayesian_FROC}()}.

To be passed to \code{\link{DrawCurves}()}, \code{\link{ppp}()}  and ... etc}
}
\value{
An object of class "character" indicating a parameter whose chain has the maximal R hat over all chains of MCMC parameters.
}
\description{
Extract a name of parameter from StanfitExtended object (or stanfit object.)
}
\examples{
\dontrun{
#========================================================================================
#                   Draw   a trace plot for a paramter whose R hat is largest
#========================================================================================


#  Fit a model to data
#______________________



      f <- fit_Bayesian_FROC(
                         ite  = 111,
                          cha = 1,
                     dataList = d)


# Extract a name of parameter whose R hat is maximal over all parameters
#____________________________________________________________________



  name <- name_of_param_whose_Rhat_is_maximal(f)



# Change the S4 class of fitted model object to apply the rstan package
#____________________________________________________________________



   # f <- methods::as(f,"stanfit")
   # for unknown error in R CMD check, the author put # before the code

# Show trace plot of a parameter whose R hat is the worst
#____________________________________________________________________



   # rstan::stan_trace(f,pars=name)
   # for unknown error in R CMD check, the author put # before the code

}

}
