/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel;

import dr.evomodel.substmodel.MarkovJumpsSubstitutionModel;
import dr.evomodel.substmodel.SubstitutionModel;
import dr.inference.markovjumps.MarkovJumpsType;
import dr.inference.markovjumps.StateHistory;
import dr.inference.markovjumps.SubordinatedProcess;
import dr.inference.markovjumps.UniformizedStateHistory;
import dr.inference.model.Model;
import java.util.logging.Logger;

public class UniformizedSubstitutionModel
extends MarkovJumpsSubstitutionModel {
    private final int numSimulants;
    private boolean updateSubordinator;
    private SubordinatedProcess subordinator;
    private SubordinatedProcess storedSubordinator;
    private boolean saveCompleteHistory = false;
    private StateHistory completeHistory = null;
    private double[] tmp;
    private static int maxRejectionAttempts = 100000;
    private static final boolean RETURN_NAN = true;
    private static boolean reportWarning = true;

    public UniformizedSubstitutionModel(SubstitutionModel substitutionModel) {
        this(substitutionModel, MarkovJumpsType.COUNTS);
    }

    public UniformizedSubstitutionModel(SubstitutionModel substitutionModel, MarkovJumpsType markovJumpsType) {
        this(substitutionModel, markovJumpsType, 1);
    }

    public UniformizedSubstitutionModel(SubstitutionModel substitutionModel, MarkovJumpsType markovJumpsType, int n) {
        super(substitutionModel, markovJumpsType);
        this.numSimulants = n;
        this.updateSubordinator = true;
    }

    @Override
    protected void setupStorage() {
        super.setupStorage();
        this.tmp = new double[this.stateCount * this.stateCount];
    }

    @Override
    protected void storeState() {
        this.storedSubordinator = this.subordinator;
    }

    @Override
    protected void restoreState() {
        this.subordinator = this.storedSubordinator;
    }

    private void constructSubordinator() {
        this.substModel.getInfinitesimalMatrix(this.tmp);
        this.subordinator = new SubordinatedProcess(this.tmp, this.stateCount);
        this.updateSubordinator = false;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.substModel) {
            this.updateSubordinator = true;
        }
        super.handleModelChangedEvent(model, object, n);
    }

    public void setSaveCompleteHistory(boolean bl) {
        this.saveCompleteHistory = bl;
    }

    @Override
    public void computeCondStatMarkovJumps(double d, double[] dArray) {
        throw new IllegalArgumentException("Not implemented for UniformizedSubstitutionModel");
    }

    @Override
    public void computeCondStatMarkovJumps(double d, double[] dArray, double[] dArray2) {
        throw new IllegalArgumentException("Not implemented for UniformizedSubstitutionModel");
    }

    @Override
    public void computeJointStatMarkovJumps(double d, double[] dArray) {
        throw new IllegalArgumentException("Not implemented for UniformizedSubstitutionModel");
    }

    public double computeCondStatMarkovJumps(int n, int n2, double d) {
        this.substModel.getTransitionProbabilities(d, this.tmp);
        return this.computeCondStatMarkovJumps(n, n2, d, this.tmp[n * this.stateCount + n2]);
    }

    public String getCompleteHistory() {
        return this.getCompleteHistory(null, null);
    }

    public String getCompleteHistory(Double d, Double d2) {
        return this.getCompleteHistory(-1, d, d2);
    }

    public String getCompleteHistory(int n, Double d, Double d2) {
        if (d != null && d2 != null) {
            this.completeHistory.rescaleTimesOfEvents(d, d2);
        }
        return this.completeHistory.toStringChanges(n, this.dataType);
    }

    public int getNumberOfJumpsInCompleteHistory() {
        return this.completeHistory == null ? -1 : this.completeHistory.getNumberOfJumps();
    }

    public double computeCondStatMarkovJumps(int n, int n2, double d, double d2) {
        if (this.updateSubordinator) {
            this.constructSubordinator();
        }
        double d3 = 0.0;
        for (int i = 0; i < this.numSimulants; ++i) {
            StateHistory stateHistory = null;
            try {
                stateHistory = UniformizedStateHistory.simulateConditionalOnEndingState(0.0, n, d, n2, d2, this.stateCount, this.subordinator);
            }
            catch (SubordinatedProcess.Exception exception) {
                if (reportWarning) {
                    Logger.getLogger("dr.app.beagle").info("Unable to compute a robust count; this is most likely due to poor starting values.");
                }
                reportWarning = false;
                return Double.NaN;
            }
            d3 += this.getProcessForSimulant(stateHistory);
            if (!this.saveCompleteHistory) continue;
            if (this.numSimulants == 1) {
                this.completeHistory = stateHistory;
                continue;
            }
            throw new RuntimeException("Use single simulant when saving complete histories");
        }
        return d3 / (double)this.numSimulants;
    }

    public StateHistory getStateHistory() {
        return this.completeHistory;
    }
}

