/*
 * Decompiled with CFR 0.152.
 */
package com.github.lbfgs4j.liblbfgs;

import com.github.lbfgs4j.liblbfgs.Arithmetic;
import com.github.lbfgs4j.liblbfgs.LbfgsConstant;
import com.github.lbfgs4j.liblbfgs.MutableDouble;

public class Lbfgs {
    static LbfgsConstant.LBFGS_Param _defparam = new LbfgsConstant.LBFGS_Param(6, 1.0E-5, 0, 1.0E-5, 0, LbfgsConstant.LineSearch.LBFGS_LINESEARCH_DEFAULT, 40, 1.0E-20, 1.0E20, 1.0E-4, 0.9, 0.9, 1.0E-16, 0.0, 0, -1);

    public static LbfgsConstant.LBFGS_Param defaultParams() {
        return new LbfgsConstant.LBFGS_Param(_defparam);
    }

    public static LbfgsConstant.ReturnValue lbfgs(int n, double[] x, MutableDouble ptr_fx, LbfgsConstant.LBFGS_Evaluate proc_evaluate, LbfgsConstant.LBFGS_Progress proc_progress, Object instance, LbfgsConstant.LBFGS_Param _param) {
        LbfgsConstant.ReturnValue ret;
        double xnorm;
        IterationData it;
        int i;
        CallbackData cd;
        LineSearchProc linesearch;
        double rate;
        MutableDouble fx;
        int m;
        LbfgsConstant.LBFGS_Param param;
        MutableDouble step;
        block50: {
            block49: {
                step = new MutableDouble();
                param = _param != null ? _param : _defparam;
                m = param.m;
                fx = new MutableDouble(0.0);
                rate = 0.0;
                linesearch = new LineSearchMorethuente();
                cd = new CallbackData();
                cd.n = n;
                cd.instance = instance;
                cd.proc_evaluate = proc_evaluate;
                cd.proc_progress = proc_progress;
                if (n <= 0) {
                    return LbfgsConstant.ReturnValue.LBFGSERR_INVALID_N;
                }
                if (param.epsilon < 0.0) {
                    return LbfgsConstant.ReturnValue.LBFGSERR_INVALID_EPSILON;
                }
                if (param.past < 0) {
                    return LbfgsConstant.ReturnValue.LBFGSERR_INVALID_TESTPERIOD;
                }
                if (param.delta < 0.0) {
                    return LbfgsConstant.ReturnValue.LBFGSERR_INVALID_DELTA;
                }
                if (param.min_step < 0.0) {
                    return LbfgsConstant.ReturnValue.LBFGSERR_INVALID_MINSTEP;
                }
                if (param.max_step < param.min_step) {
                    return LbfgsConstant.ReturnValue.LBFGSERR_INVALID_MAXSTEP;
                }
                if (param.ftol < 0.0) {
                    return LbfgsConstant.ReturnValue.LBFGSERR_INVALID_FTOL;
                }
                if ((param.lineSearch == LbfgsConstant.LineSearch.LBFGS_LINESEARCH_BACKTRACKING_WOLFE || param.lineSearch == LbfgsConstant.LineSearch.LBFGS_LINESEARCH_BACKTRACKING_STRONG_WOLFE) && (param.wolfe <= param.ftol || 1.0 <= param.wolfe)) {
                    return LbfgsConstant.ReturnValue.LBFGSERR_INVALID_WOLFE;
                }
                if (param.gtol < 0.0) {
                    return LbfgsConstant.ReturnValue.LBFGSERR_INVALID_GTOL;
                }
                if (param.xtol < 0.0) {
                    return LbfgsConstant.ReturnValue.LBFGSERR_INVALID_XTOL;
                }
                if (param.max_linesearch <= 0) {
                    return LbfgsConstant.ReturnValue.LBFGSERR_INVALID_MAXLINESEARCH;
                }
                if (param.orthantwise_c < 0.0) {
                    return LbfgsConstant.ReturnValue.LBFGSERR_INVALID_ORTHANTWISE;
                }
                if (param.orthantwise_start < 0 || n < param.orthantwise_start) {
                    return LbfgsConstant.ReturnValue.LBFGSERR_INVALID_ORTHANTWISE_START;
                }
                if (param.orthantwise_end < 0) {
                    param.orthantwise_end = n;
                }
                if (n < param.orthantwise_end) {
                    return LbfgsConstant.ReturnValue.LBFGSERR_INVALID_ORTHANTWISE_END;
                }
                if (param.orthantwise_c == 0.0) break block49;
                switch (param.lineSearch) {
                    case LBFGS_LINESEARCH_BACKTRACKING: {
                        linesearch = new LineSearchBacktrackingOWLQN();
                        break block50;
                    }
                    default: {
                        return LbfgsConstant.ReturnValue.LBFGSERR_INVALID_LINESEARCH;
                    }
                }
            }
            switch (param.lineSearch) {
                case LBFGS_LINESEARCH_DEFAULT: 
                case LBFGS_LINESEARCH_MORETHUENTE: {
                    linesearch = new LineSearchMorethuente();
                    break;
                }
                case LBFGS_LINESEARCH_BACKTRACKING_ARMIJO: 
                case LBFGS_LINESEARCH_BACKTRACKING_WOLFE: 
                case LBFGS_LINESEARCH_BACKTRACKING_STRONG_WOLFE: {
                    linesearch = new LineSearchBacktracking();
                    break;
                }
                default: {
                    return LbfgsConstant.ReturnValue.LBFGSERR_INVALID_LINESEARCH;
                }
            }
        }
        double[] xp = new double[n];
        double[] g = new double[n];
        double[] gp = new double[n];
        double[] d = new double[n];
        double[] w = new double[n];
        double[] pg = null;
        if (param.orthantwise_c != 0.0) {
            pg = new double[n];
        }
        IterationData[] lm = new IterationData[m];
        for (i = 0; i < m; ++i) {
            it = new IterationData();
            it.alpha = 0.0;
            it.ys = 0.0;
            it.s = new double[n];
            it.y = new double[n];
            lm[i] = it;
        }
        double[] pf = null;
        if (0 < param.past) {
            pf = new double[param.past];
        }
        fx.val = cd.proc_evaluate.eval(cd.instance, x, g, cd.n, 0.0);
        if (0.0 != param.orthantwise_c) {
            xnorm = Lbfgs.owlqnX1Norm(x, param.orthantwise_start, param.orthantwise_end);
            fx.val += xnorm * param.orthantwise_c;
            Lbfgs.owlqnPseudoGradient(pg, x, g, n, param.orthantwise_c, param.orthantwise_start, param.orthantwise_end);
        }
        if (pf != null) {
            pf[0] = fx.val;
        }
        if (param.orthantwise_c == 0.0) {
            Arithmetic.vecncpy(d, g, n);
        } else {
            Arithmetic.vecncpy(d, pg, n);
        }
        xnorm = Arithmetic.vec2norm(x, n);
        double gnorm = param.orthantwise_c == 0.0 ? Arithmetic.vec2norm(g, n) : Arithmetic.vec2norm(pg, n);
        if (xnorm < 1.0) {
            xnorm = 1.0;
        }
        if (gnorm / xnorm <= param.epsilon) {
            return LbfgsConstant.ReturnValue.LBFGS_ALREADY_MINIMIZED;
        }
        step.val = Arithmetic.vec2norminv(d, n);
        int k = 1;
        int end = 0;
        while (true) {
            LbfgsConstant.ReturnValue ls;
            Arithmetic.veccpy(xp, x, n);
            Arithmetic.veccpy(gp, g, n);
            if (param.orthantwise_c == 0.0) {
                ls = linesearch.eval(n, x, fx, g, d, step, xp, gp, w, cd, param);
            } else {
                ls = linesearch.eval(n, x, fx, g, d, step, xp, pg, w, cd, param);
                Lbfgs.owlqnPseudoGradient(pg, x, g, n, param.orthantwise_c, param.orthantwise_start, param.orthantwise_end);
            }
            if (ls.val < 0) {
                Arithmetic.veccpy(x, xp, n);
                Arithmetic.veccpy(g, gp, n);
                return ls;
            }
            xnorm = Arithmetic.vec2norm(x, n);
            gnorm = param.orthantwise_c == 0.0 ? Arithmetic.vec2norm(g, n) : Arithmetic.vec2norm(pg, n);
            if (cd.proc_progress != null) {
                ret = cd.proc_progress.eval(cd.instance, x, g, fx.val, xnorm, gnorm, step.val, cd.n, k, ls.val);
                if (ret.val > 0) {
                    return ret;
                }
            }
            if (xnorm < 1.0) {
                xnorm = 1.0;
            }
            if (gnorm / xnorm <= param.epsilon) {
                ret = LbfgsConstant.ReturnValue.LBFGS_SUCCESS;
                break;
            }
            if (pf != null) {
                if (param.past <= k && (rate = (pf[k % param.past] - fx.val) / fx.val) < param.delta) {
                    ret = LbfgsConstant.ReturnValue.LBFGS_STOP;
                    break;
                }
                pf[k % param.past] = fx.val;
            }
            if (param.max_iterations != 0 && param.max_iterations < k + 1) {
                ret = LbfgsConstant.ReturnValue.LBFGSERR_MAXIMUMITERATION;
                break;
            }
            it = lm[end];
            Arithmetic.vecdiff(it.s, x, xp, n);
            Arithmetic.vecdiff(it.y, g, gp, n);
            double ys = Arithmetic.vecdot(it.y, it.s, n);
            double yy = Arithmetic.vecdot(it.y, it.y, n);
            it.ys = ys;
            int bound = m <= k ? m : k;
            ++k;
            end = (end + 1) % m;
            if (param.orthantwise_c == 0.0) {
                Arithmetic.vecncpy(d, g, n);
            } else {
                Arithmetic.vecncpy(d, pg, n);
            }
            int j = end;
            for (i = 0; i < bound; ++i) {
                j = (j + m - 1) % m;
                it = lm[j];
                it.alpha = Arithmetic.vecdot(it.s, d, n);
                it.alpha /= it.ys;
                Arithmetic.vecadd(d, it.y, -it.alpha, n);
            }
            Arithmetic.vecscale(d, ys / yy, n);
            for (i = 0; i < bound; ++i) {
                it = lm[j];
                double beta = Arithmetic.vecdot(it.y, d, n);
                Arithmetic.vecadd(d, it.s, it.alpha - (beta /= it.ys), n);
                j = (j + 1) % m;
            }
            if (param.orthantwise_c != 0.0) {
                for (i = param.orthantwise_start; i < param.orthantwise_end; ++i) {
                    if (!(d[i] * pg[i] >= 0.0)) continue;
                    d[i] = 0.0;
                }
            }
            step.val = 1.0;
        }
        if (ptr_fx != null) {
            ptr_fx.val = fx.val;
        }
        return ret;
    }

    static double cubicMinimizer(double u, double fu, double du, double v, double fv, double dv) {
        double d = v - u;
        double theta = (fu - fv) * 3.0 / d + du + dv;
        double p = Math.abs(theta);
        double q = Math.abs(du);
        double r = Math.abs(dv);
        double s = Math.max(Math.max(p, q), r);
        double a = theta / s;
        double gamma = s * Math.sqrt(a * a - du / s * (dv / s));
        if (v < u) {
            gamma = -gamma;
        }
        p = gamma - du + theta;
        q = gamma - du + gamma + dv;
        r = p / q;
        double cm = u + r * d;
        return cm;
    }

    static double cubicMinimizer2(double u, double fu, double du, double v, double fv, double dv, double xmin, double xmax) {
        double d = v - u;
        double theta = (fu - fv) * 3.0 / d + du + dv;
        double p = Math.abs(theta);
        double q = Math.abs(du);
        double r = Math.abs(dv);
        double s = Math.max(Math.max(p, q), r);
        double a = theta / s;
        double gamma = s * Math.sqrt(Math.max(0.0, a * a - du / s * (dv / s)));
        if (u < v) {
            gamma = -gamma;
        }
        double cm = (r = (p = gamma - dv + theta) / (q = gamma - dv + gamma + du)) < 0.0 && gamma != 0.0 ? v - r * d : (a < 0.0 ? xmax : xmin);
        return cm;
    }

    static double quardMinimizer(double u, double fu, double du, double v, double fv) {
        double a = v - u;
        double qm = u + du / ((fu - fv) / a + du) / 2.0 * a;
        return qm;
    }

    static double quardMinimizer2(double u, double du, double v, double dv) {
        double a = u - v;
        double qm = v + dv / (dv - du) * a;
        return qm;
    }

    static LbfgsConstant.ReturnValue updateTrialInterval(MutableDouble x, MutableDouble fx, MutableDouble dx, MutableDouble y, MutableDouble fy, MutableDouble dy, MutableDouble t, MutableDouble ft, MutableDouble dt, double tmin, double tmax, MutableDouble brackt) {
        double newt;
        double mq;
        int bound;
        boolean dsign = Arithmetic.fsigndiff(dt.val, dx.val);
        if (brackt.val > 0.0) {
            if (t.val <= Math.min(x.val, y.val) || Math.max(x.val, y.val) <= t.val) {
                return LbfgsConstant.ReturnValue.LBFGSERR_OUTOFINTERVAL;
            }
            if (0.0 <= dx.val * (t.val - x.val)) {
                return LbfgsConstant.ReturnValue.LBFGSERR_INCREASEGRADIENT;
            }
            if (tmax < tmin) {
                return LbfgsConstant.ReturnValue.LBFGSERR_INCORRECT_TMINMAX;
            }
        }
        if (fx.val < ft.val) {
            brackt.val = 1.0;
            bound = 1;
            double mc = Lbfgs.cubicMinimizer(x.val, fx.val, dx.val, t.val, ft.val, dt.val);
            mq = Lbfgs.quardMinimizer(x.val, fx.val, dx.val, t.val, ft.val);
            newt = Math.abs(mc - x.val) < Math.abs(mq - x.val) ? mc : mc + 0.5 * (mq - mc);
        } else if (dsign) {
            brackt.val = 1.0;
            bound = 0;
            double mc = Lbfgs.cubicMinimizer(x.val, fx.val, dx.val, t.val, ft.val, dt.val);
            mq = Lbfgs.quardMinimizer2(x.val, dx.val, t.val, dt.val);
            newt = Math.abs(mc - t.val) > Math.abs(mq - t.val) ? mc : mq;
        } else if (Math.abs(dt.val) < Math.abs(dx.val)) {
            bound = 1;
            double mc = Lbfgs.cubicMinimizer2(x.val, fx.val, dx.val, t.val, ft.val, dt.val, tmin, tmax);
            mq = Lbfgs.quardMinimizer2(x.val, dx.val, t.val, dt.val);
            newt = brackt.val > 0.0 ? (Math.abs(t.val - mc) < Math.abs(t.val - mq) ? mc : mq) : (Math.abs(t.val - mc) > Math.abs(t.val - mq) ? mc : mq);
        } else {
            bound = 0;
            newt = brackt.val > 0.0 ? Lbfgs.cubicMinimizer(t.val, ft.val, dt.val, y.val, fy.val, dy.val) : (x.val < t.val ? tmax : tmin);
        }
        if (fx.val < ft.val) {
            y.val = t.val;
            fy.val = ft.val;
            dy.val = dt.val;
        } else {
            if (dsign) {
                y.val = x.val;
                fy.val = fx.val;
                dy.val = dx.val;
            }
            x.val = t.val;
            fx.val = ft.val;
            dx.val = dt.val;
        }
        if (tmax < newt) {
            newt = tmax;
        }
        if (newt < tmin) {
            newt = tmin;
        }
        if (brackt.val > 0.0 && bound > 0) {
            mq = x.val + 0.66 * (y.val - x.val);
            if (x.val < y.val) {
                if (mq < newt) {
                    newt = mq;
                }
            } else if (newt < mq) {
                newt = mq;
            }
        }
        t.val = newt;
        return LbfgsConstant.ReturnValue.LBFGS_SUCCESS;
    }

    static double owlqnX1Norm(double[] x, int start, int n) {
        double norm = 0.0;
        for (int i = start; i < n; ++i) {
            norm += Math.abs(x[i]);
        }
        return norm;
    }

    static void owlqnPseudoGradient(double[] pg, double[] x, double[] g, int n, double c, int start, int end) {
        int i;
        for (i = 0; i < start; ++i) {
            pg[i] = g[i];
        }
        for (i = start; i < end; ++i) {
            pg[i] = x[i] < 0.0 ? g[i] - c : (0.0 < x[i] ? g[i] + c : (g[i] < -c ? g[i] + c : (c < g[i] ? g[i] - c : 0.0)));
        }
        for (i = end; i < n; ++i) {
            pg[i] = g[i];
        }
    }

    static void owlqnProject(double[] d, double[] sign, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (!(d[i] * sign[i] <= 0.0)) continue;
            d[i] = 0.0;
        }
    }

    static class LineSearchMorethuente
    implements LineSearchProc {
        LineSearchMorethuente() {
        }

        @Override
        public LbfgsConstant.ReturnValue eval(int n, double[] x, MutableDouble f, double[] g, double[] s, MutableDouble stp, double[] xp, double[] gp, double[] wa, CallbackData cd, LbfgsConstant.LBFGS_Param param) {
            int count = 0;
            LbfgsConstant.ReturnValue uinfo = LbfgsConstant.ReturnValue.LBFGS_SUCCESS;
            MutableDouble dg = new MutableDouble();
            MutableDouble stx = new MutableDouble();
            MutableDouble fx = new MutableDouble();
            MutableDouble dgx = new MutableDouble();
            MutableDouble sty = new MutableDouble();
            MutableDouble fy = new MutableDouble();
            MutableDouble dgy = new MutableDouble();
            MutableDouble fxm = new MutableDouble();
            MutableDouble dgxm = new MutableDouble();
            MutableDouble fym = new MutableDouble();
            MutableDouble dgym = new MutableDouble();
            MutableDouble fm = new MutableDouble();
            MutableDouble dgm = new MutableDouble();
            if (stp.val <= 0.0) {
                return LbfgsConstant.ReturnValue.LBFGSERR_INVALIDPARAMETERS;
            }
            double dginit = Arithmetic.vecdot(g, s, n);
            if (0.0 < dginit) {
                return LbfgsConstant.ReturnValue.LBFGSERR_INCREASEGRADIENT;
            }
            MutableDouble brackt = new MutableDouble(0.0);
            int stage1 = 1;
            double finit = f.val;
            double dgtest = param.ftol * dginit;
            double width = param.max_step - param.min_step;
            double prev_width = 2.0 * width;
            sty.val = 0.0;
            stx.val = 0.0;
            fx.val = fy.val = finit;
            dgx.val = dgy.val = dginit;
            while (true) {
                double stmax;
                double stmin;
                if (brackt.val > 0.0) {
                    stmin = Math.min(stx.val, sty.val);
                    stmax = Math.max(stx.val, sty.val);
                } else {
                    stmin = stx.val;
                    stmax = stp.val + 4.0 * (stp.val - stx.val);
                }
                if (stp.val < param.min_step) {
                    stp.val = param.min_step;
                }
                if (param.max_step < stp.val) {
                    stp.val = param.max_step;
                }
                if (brackt.val > 0.0 && (stp.val <= stmin || stmax <= stp.val || param.max_linesearch <= count + 1 || uinfo.val != 0) || brackt.val > 0.0 && stmax - stmin <= param.xtol * stmax) {
                    stp.val = stx.val;
                }
                Arithmetic.veccpy(x, xp, n);
                Arithmetic.vecadd(x, s, stp.val, n);
                f.val = cd.proc_evaluate.eval(cd.instance, x, g, cd.n, stp.val);
                dg.val = Arithmetic.vecdot(g, s, n);
                double ftest1 = finit + stp.val * dgtest;
                ++count;
                if (brackt.val > 0.0 && (stp.val <= stmin || stmax <= stp.val || uinfo.val != 0)) {
                    return LbfgsConstant.ReturnValue.LBFGSERR_ROUNDING_ERROR;
                }
                if (stp.val == param.max_step && f.val <= ftest1 && dg.val <= dgtest) {
                    return LbfgsConstant.ReturnValue.LBFGSERR_MAXIMUMSTEP;
                }
                if (stp.val == param.min_step && (ftest1 < f.val || dgtest <= dg.val)) {
                    return LbfgsConstant.ReturnValue.LBFGSERR_MINIMUMSTEP;
                }
                if (brackt.val > 0.0 && stmax - stmin <= param.xtol * stmax) {
                    return LbfgsConstant.ReturnValue.LBFGSERR_WIDTHTOOSMALL;
                }
                if (param.max_linesearch <= count) {
                    return LbfgsConstant.ReturnValue.LBFGSERR_MAXIMUMLINESEARCH;
                }
                if (f.val <= ftest1 && Math.abs(dg.val) <= param.gtol * -dginit) {
                    return LbfgsConstant.ReturnValue.LBFGS_SUCCESS;
                }
                if (stage1 > 0 && f.val <= ftest1 && Math.min(param.ftol, param.gtol) * dginit <= dg.val) {
                    stage1 = 0;
                }
                if (stage1 > 0 && ftest1 < f.val && f.val <= fx.val) {
                    fm.val = f.val - stp.val * dgtest;
                    fxm.val = fx.val - stx.val * dgtest;
                    fym.val = fy.val - sty.val * dgtest;
                    dgm.val = dg.val - dgtest;
                    dgxm.val = dgx.val - dgtest;
                    dgym.val = dgy.val - dgtest;
                    uinfo = Lbfgs.updateTrialInterval(stx, fxm, dgxm, sty, fym, dgym, stp, fm, dgm, stmin, stmax, brackt);
                    fx.val = fxm.val + stx.val * dgtest;
                    fy.val = fym.val + sty.val * dgtest;
                    dgx.val = dgxm.val + dgtest;
                    dgy.val = dgym.val + dgtest;
                } else {
                    uinfo = Lbfgs.updateTrialInterval(stx, fx, dgx, sty, fy, dgy, stp, f, dg, stmin, stmax, brackt);
                }
                if (!(brackt.val > 0.0)) continue;
                if (0.66 * prev_width <= Math.abs(sty.val - stx.val)) {
                    stp.val = stx.val + 0.5 * (sty.val - stx.val);
                }
                prev_width = width;
                width = Math.abs(sty.val - stx.val);
            }
        }
    }

    static class LineSearchBacktrackingOWLQN
    implements LineSearchProc {
        LineSearchBacktrackingOWLQN() {
        }

        @Override
        public LbfgsConstant.ReturnValue eval(int n, double[] x, MutableDouble f, double[] g, double[] s, MutableDouble stp, double[] xp, double[] gp, double[] wp, CallbackData cd, LbfgsConstant.LBFGS_Param param) {
            int i;
            int count = 0;
            double width = 0.5;
            double norm = 0.0;
            double finit = f.val;
            if (stp.val <= 0.0) {
                return LbfgsConstant.ReturnValue.LBFGSERR_INVALIDPARAMETERS;
            }
            for (i = 0; i < n; ++i) {
                wp[i] = xp[i] == 0.0 ? -gp[i] : xp[i];
            }
            while (true) {
                Arithmetic.veccpy(x, xp, n);
                Arithmetic.vecadd(x, s, stp.val, n);
                Lbfgs.owlqnProject(x, wp, param.orthantwise_start, param.orthantwise_end);
                f.val = cd.proc_evaluate.eval(cd.instance, x, g, cd.n, stp.val);
                norm = Lbfgs.owlqnX1Norm(x, param.orthantwise_start, param.orthantwise_end);
                f.val += norm * param.orthantwise_c;
                ++count;
                double dgtest = 0.0;
                for (i = 0; i < n; ++i) {
                    dgtest += (x[i] - xp[i]) * gp[i];
                }
                if (f.val <= finit + param.ftol * dgtest) {
                    return LbfgsConstant.ReturnValue.LBFGS_SUCCESS;
                }
                if (stp.val < param.min_step) {
                    return LbfgsConstant.ReturnValue.LBFGSERR_MINIMUMSTEP;
                }
                if (stp.val > param.max_step) {
                    return LbfgsConstant.ReturnValue.LBFGSERR_MAXIMUMSTEP;
                }
                if (param.max_linesearch <= count) {
                    return LbfgsConstant.ReturnValue.LBFGSERR_MAXIMUMLINESEARCH;
                }
                stp.val *= width;
            }
        }
    }

    static class LineSearchBacktracking
    implements LineSearchProc {
        LineSearchBacktracking() {
        }

        @Override
        public LbfgsConstant.ReturnValue eval(int n, double[] x, MutableDouble f, double[] g, double[] s, MutableDouble stp, double[] xp, double[] gp, double[] wp, CallbackData cd, LbfgsConstant.LBFGS_Param param) {
            int count = 0;
            double dginit = 0.0;
            double dec = 0.5;
            double inc = 2.1;
            if (stp.val <= 0.0) {
                return LbfgsConstant.ReturnValue.LBFGSERR_INVALIDPARAMETERS;
            }
            dginit = Arithmetic.vecdot(g, s, n);
            if (0.0 < dginit) {
                return LbfgsConstant.ReturnValue.LBFGSERR_INCREASEGRADIENT;
            }
            double finit = f.val;
            double dgtest = param.ftol * dginit;
            while (true) {
                double width;
                Arithmetic.veccpy(x, xp, n);
                Arithmetic.vecadd(x, s, stp.val, n);
                f.val = cd.proc_evaluate.eval(cd.instance, x, g, cd.n, stp.val);
                ++count;
                if (f.val > finit + stp.val * dgtest) {
                    width = dec;
                } else {
                    if (param.lineSearch == LbfgsConstant.LineSearch.LBFGS_LINESEARCH_BACKTRACKING_ARMIJO) {
                        return LbfgsConstant.ReturnValue.LBFGS_SUCCESS;
                    }
                    double dg = Arithmetic.vecdot(g, s, n);
                    if (dg < param.wolfe * dginit) {
                        width = inc;
                    } else {
                        if (param.lineSearch == LbfgsConstant.LineSearch.LBFGS_LINESEARCH_BACKTRACKING_WOLFE) {
                            return LbfgsConstant.ReturnValue.LBFGS_SUCCESS;
                        }
                        if (dg > -param.wolfe * dginit) {
                            width = dec;
                        } else {
                            return LbfgsConstant.ReturnValue.LBFGS_SUCCESS;
                        }
                    }
                }
                if (stp.val < param.min_step) {
                    return LbfgsConstant.ReturnValue.LBFGSERR_MINIMUMSTEP;
                }
                if (stp.val > param.max_step) {
                    return LbfgsConstant.ReturnValue.LBFGSERR_MAXIMUMSTEP;
                }
                if (param.max_linesearch <= count) {
                    return LbfgsConstant.ReturnValue.LBFGSERR_MAXIMUMLINESEARCH;
                }
                stp.val *= width;
            }
        }
    }

    static interface LineSearchProc {
        public LbfgsConstant.ReturnValue eval(int var1, double[] var2, MutableDouble var3, double[] var4, double[] var5, MutableDouble var6, double[] var7, double[] var8, double[] var9, CallbackData var10, LbfgsConstant.LBFGS_Param var11);
    }

    static class IterationData {
        double alpha;
        double[] s;
        double[] y;
        double ys;

        IterationData() {
        }
    }

    static class CallbackData {
        int n;
        Object instance;
        LbfgsConstant.LBFGS_Evaluate proc_evaluate;
        LbfgsConstant.LBFGS_Progress proc_progress;

        CallbackData() {
        }
    }
}

